/*
 *   This file is part of the MLV Library.
 *
 *   Copyright (C) 2010 Adrien Boussicault, Marc Zipstein
 *
 *
 *    This Library is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    This Library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this Library.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file MLV_time.h
 *
 * \author Adrien Boussicault
 * \author Marc Zipstein
 *
 * \brief Ce fichier définit tous les prototypes des fonctions concernant la gestion du temps.
 * 
 */

#ifndef __MLV_TIME_H__
#define __MLV_TIME_H__

/**
 * \brief Le programme s'intérompt pendant un nombre de milli-secondes.
 *
 * \param milliseconds Le nombre de milli-secondes à attendre.
 */
void MLV_wait_milliseconds(int milliseconds);

/**
 * \brief Le programme s'intérompt pendant un nombre de secondes.
 *
 * \param seconds Le nombre de secondes à attendre.
 */
void MLV_wait_seconds(int seconds);

/**
 * \brief Renvoie le nombre de millisecondes écoulées depuis le début de l'initialisation de la librairie MLV ( avec MLV_create_window ).
 * \return Le temps écoulé depuis l'initiaslisation de la librairies MLV.
 */
int MLV_get_time();

#endif
