<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_ucp_profile extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','ucp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $uid = XF::sanitize_var(XF::ifset('get','user',XF::vault_query('current_user_id')),'int');
  $sep = XF::sanitize_var(XF::ifset('get','sep',false),'bool');
  $this->gpc = array('uid'=>$uid,'sep'=>$sep);
  $group = XF::get_group('*');
  $cg = XF::vault_query('current_group_id');
    if ( !$group[$cg]['g_executive'] )
    $this->gpc['uid'] = XF::vault_query('current_user_id');
  unset($uid,$sep);

  $user = XF::get_user($this->gpc['uid']);
  $perm = array();
    if ( !$user )
    XFUI::html_redirect(-1,XF::link('overview'));
    if ( $this->gpc['sep'] && $group[$cg]['g_executive'] ){
    XFUI::load_lang_res('','acpacl');
    $sacl = XF::sql_query("SELECT a_action FROM ".XF::tbl('acl')." GROUP BY a_action ORDER BY a_action",'',__METHOD__,__LINE__);
      while ( $r = $sacl->fetchObject() )
      $perm[$r->a_action] = array('lang'=>'acl_seg_'.$r->a_action,'access'=>XF::access_control($r->a_action,$user['u_id'],$user['u_group']));
    $sacl->closeCursor();
    }
  $languages = explode(',',XF::vault_query('available_languages'));
  $styles = explode(',',XF::vault_query('available_styles'));

  XF::tan('acp_user_delete');
  XF::tan('ucp_profile');
  XFUI::ajax_init();
  XFUI::html_head('{:my_profile_settings}');
  XF::$tpl->clear_cache('form_ucp_profile.tpl');
  XF::$tpl->assign('userid',$this->gpc['uid']);
  XF::$tpl->assign('current_user',XF::get_user());
  XF::$tpl->assign('show_effective_permission',$this->gpc['sep']);
  XF::$tpl->assign('executive_mode',$group[$cg]['g_executive']);
  XF::$tpl->assign('user_data',$user);
  XF::$tpl->assign('groups',$group);
  XF::$tpl->assign('languages',$languages);
  XF::$tpl->assign('styles',$styles);
  XF::$tpl->assign('timezones',DateTimeZone::listIdentifiers());
  XF::$tpl->assign('post_license',unserialize(XF::vault_query('post_license')));
  XF::$tpl->assign('permission',$perm);
  XF::$tpl->display('form_ucp_profile.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $info = XF::sanitize_var(XF::ifset($input,'f_info',''),'str','okifempty,length=0-255,stripspaces');
  $mail = XF::sanitize_var(XF::ifset($input,'f_mail',''),'mail','okifempty');
  $style = XF::sanitize_var(XF::ifset($input,'f_style',''),'style','okifempty');
  $language = XF::sanitize_var(XF::ifset($input,'f_language',''),'lang','okifempty');
  $timezone = XF::sanitize_var(XF::ifset($input,'f_timezone',''),'str','okifempty,length=0-64');
  $time24h = XF::sanitize_var(XF::ifset($input,'f_time24h',0),'booli');
  $auto_bookmark = XF::sanitize_var(XF::ifset($input,'f_auto_bookmark',0),'booli');
  $login_liberal = XF::sanitize_var(XF::ifset($input,'f_login_liberal',0),'booli');
  $post_license = XF::sanitize_var(XF::ifset($input,'f_post_license','none'),'enum','o=none,o=ccbysa,o=ccbynd');
  $pass_old = XF::sanitize_var(XF::ifset($input,'f_pass_o_hash',''),'str','restrict');
  $pass_new1 = XF::sanitize_var(XF::ifset($input,'f_pass_1_hash',''),'str','restrict');
  $pass_new2 = XF::sanitize_var(XF::ifset($input,'f_pass_2_hash',''),'str','restrict');
  $active = XF::sanitize_var(XF::ifset($input,'f_active',0),'booli');
  $login_annoy = XF::sanitize_var(XF::ifset($input,'f_login_annoy',0),'booli');
  $warning = XF::sanitize_var(XF::ifset($input,'f_warning','none'),'enum','o=none,o=low,o=medium,o=high');
  $approve = XF::sanitize_var(XF::ifset($input,'f_approve','default'),'enum','o=default,o=true,o=false');
  $comment = XF::sanitize_var(XF::ifset($input,'f_comment',''),'str','okifempty,length=0-255,stripspaces');
  $group = XF::sanitize_var(XF::ifset($input,'f_group',XF::get_cfg('main_default_group')),'int');
  $this->gpc = array('id'=>$id,'f_mail'=>$mail,'f_info'=>$info,'f_style'=>$style,'f_language'=>$language,'f_timezone'=>$timezone,
  'f_time24h'=>$time24h,'f_auto_bookmark'=>$auto_bookmark,'f_login_liberal'=>$login_liberal,'f_post_license'=>$post_license,
  'f_pass_o'=>$pass_old,'f_pass_1'=>$pass_new1,'f_pass_2'=>$pass_new2,'f_active'=>$active,'f_login_annoy'=>$login_annoy,
  'f_warning'=>$warning,'f_comment'=>$comment,'f_approve'=>$approve,'f_group'=>$group);
  $this->markgpc = array('f_mail','f_pass_o','f_pass_1','f_pass_2');
  return true;
  }

  /**
  * modify an user profile
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $user = XF::get_user($this->gpc['id']);
    $group = XF::get_group();
    $setpw = false;
      if ( $this->gpc['id'] !== XF::vault_query('current_user_id') && !$group['g_executive'] )
      $this->error = '{:must_not_edit_foreign_profile}';
      if ( !$user && empty($this->error) )
      $this->error = '{:no_valid_id}';
      if ( $this->gpc['f_pass_1'] !== sha1(sha1('')) && $this->gpc['f_pass_o'] !== $this->gpc['f_pass_1'] && empty($this->error) ){
      require_once(XF::vault_query('root_path').'/class.auth.php');
        if ( $this->gpc['id'] === XF::vault_query('current_user_id') ){ // a users own password must be confirmed...
        $susr = XF::sql_query("SELECT u_password FROM ".XF::tbl('user')." WHERE u_id = :userid",array('userid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
        $userpwd = $susr->fetchObject();
        $susr->closeCursor();
          if ( !XFAuth::validate_password($userpwd->u_password,$this->gpc['f_pass_o']) && empty($this->error) )
          $this->error = '{:old_password_not_correct}';
        }
        else
        $this->gpc['f_pass_o'] = '**dummy**';

        if ( $this->gpc['f_pass_1'] !== $this->gpc['f_pass_2'] && empty($this->error) )
        $this->error = '{:new_passwords_not_equal}';
        //if ( ( strlen($this->gpc['f_pass_2']) < 5 || strlen($this->gpc['f_pass_2']) > 31 ) && empty($this->error) )
        //$this->error = '{:new_password_too_short}';
        if ( empty($this->error) )
        $setpw = true;
      }
      if ( strlen($this->gpc['f_mail']) >= 3 && strpos($this->gpc['f_mail'],'@') ){
        if ( !checkdnsrr(substr($this->gpc['f_mail'],strpos($this->gpc['f_mail'],'@')+1),'MX') ){
          if ( !checkdnsrr(substr($this->gpc['f_mail'],strpos($this->gpc['f_mail'],'@')+1),'A') )
          $this->error = '{:mail_has_no_mx_dns_record}';
        }
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $la = array('info','userid',$this->gpc['id']);
      $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_mail = :mail, u_info = :info, u_language = :language,
      u_timezone = :timezone, u_time24h = :time24h, u_style = :style, u_login_liberal = :login_liberal,
      u_auto_bookmark = :auto_bookmark, u_post_license = :post_license
      WHERE u_id = :id",
      array('id'=>array($this->gpc['id'],'int'),
      'info'=>array($this->gpc['f_info'],'str'),
      'mail'=>array($this->gpc['f_mail'],'str'),
      'language'=>array($this->gpc['f_language'],'str'),
      'timezone'=>array($this->gpc['f_timezone'],'str'),
      'time24h'=>array($this->gpc['f_time24h'],'str'),
      'style'=>array($this->gpc['f_style'],'str'),
      'login_liberal'=>array($this->gpc['f_login_liberal'],'str'),
      'auto_bookmark'=>array($this->gpc['f_auto_bookmark'],'int'),
      'post_license'=>array($this->gpc['f_post_license'],'str')),__METHOD__,__LINE__);
        if ( !$u )
        throw new XFE('could not update profile for user "'.$this->gpc['id'].'"');
        if ( $setpw ){
        XF::sql_query("UPDATE ".XF::tbl('user')." SET u_password = :password WHERE u_id = :id",
        array('id'=>array($this->gpc['id'],'int'),
        'password'=>array(XF::hash($this->gpc['f_pass_2']),'str')),__METHOD__,__LINE__);
        }
        if ( $group['g_executive'] ){
        XF::sql_query("UPDATE ".XF::tbl('user')." SET u_active = :active, u_login_annoy = :login_annoy,
        u_warning_level = :warning, u_comment = :comment, u_group = :group, u_post_approved = :approve WHERE u_id = :id",
        array('id'=>array($this->gpc['id'],'int'),
        'active'=>array($this->gpc['f_active'],'str'),
        'login_annoy'=>array($this->gpc['f_login_annoy'],'str'),
        'warning'=>array($this->gpc['f_warning'],'str'),
        'comment'=>array($this->gpc['f_comment'],'str'),
        'group'=>array($this->gpc['f_group'],'int'),
        'approve'=>array($this->gpc['f_approve'],'str')),__METHOD__,__LINE__);
        XFCache::statistic('user','rebuild');
          if ( XF::$tpl->is_cached('mcp_overview.tpl') )
          XF::$tpl->clear_cache('mcp_overview.tpl');
        }
        foreach ( $this->gpc as $k=>$v ){
          if ( in_array($k,array('id','f_info','f_pass_o','f_pass_1','f_pass_2'),true) )
          continue;
          if ( !$group['g_executive'] && in_array($k,array('f_active','f_login_annoy','f_warning','f_comment','f_group','f_approve'),true) )
          continue;
        $la[] = substr($k,2);
        $la[] = $v;
        }
      XFCache::purge('user',$this->gpc['id']);
      XF::logger($la);
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_ucp_profile($input){
  $a = new XFAction_ucp_profile();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('overview','',false),'{:profile_successfully_saved}');
    else
    return xfaf_failure($a->get_error());
  }

  // implementation for windows as it doesn't support checkdnsrr() native...
  // by: developer at sysco dot ch @ 15-May-2007 06:05
  // http://de2.php.net/manual/en/function.checkdnsrr.php
  // @saturas: changed syntax, replaced eregi() with preg_match() as it's binary-safe.
  if( !function_exists('checkdnsrr') ){
    function checkdnsrr($hostname,$rectype = ''){
      if ( !empty($hostname)){
        if ( $rectype === '' )
        $rectype = 'MX';
      exec('nslookup -type='.$rectype.' '.$hostname,$result);
      // check each line to find the one that starts with the host
      // name. If it exists then the function succeeded.
        foreach ( $result as $line ){
          if ( preg_match('/^'.$hostname.'/iD',$line) )
          return true;
        }
      // otherwise there was no mail handler for the domain
      return false;
      }
    return false;
    }
  }

?>