<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_lock extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucmsg = '';
public $sucid = '';
public $sucss = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','mcp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'post',0),'int');
  $this->gpc = array('id'=>$id);
  return true;
  }

  /**
  * lock or open a topic
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $schk = XF::sql_query("SELECT p_closed,p_pp_id FROM ".XF::tbl('post_meta')." WHERE p_id = :id AND p_is_topic = true",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $topicdata = $schk->fetchObject();
    $schk->closeCursor();
      if ( !is_object($topicdata) )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_meta'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $pp = XFUI::get_post_prefix_list();
      $new = ( (bool)$topicdata->p_closed ) ? false : true;
      $u = XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_closed = :status WHERE p_id = :id AND p_is_topic = true",
      array('id'=>array($this->gpc['id'],'int'),
      'status'=>array((int)$new,'str')),__METHOD__,__LINE__);
        if ( !$u )
        throw new XFE('could not update status (open/close) for posting "'.$this->gpc['id'].'"');
      XF::logger(':'.$u,'postid',$this->gpc['id'],'is_now_closed',XF::bool2yn($new));
      XF::sql_transaction('commit');
        if ( (int)$topicdata->p_pp_id > 0 && $pp[(int)$topicdata->p_pp_id]['pp_list_as_request'] ){
          if ( XF::$tpl->is_cached('mcp_request.tpl') )
          XF::$tpl->clear_cache('mcp_request.tpl');
          if ( XF::$tpl->is_cached('acp_overview_request.tpl') )
          XF::$tpl->clear_cache('acp_overview_request.tpl');
        }
      XF::tpl_use_cache_pool($this->gpc['id'],'begin');
        if ( XF::$tpl->is_cached('post.tpl',$this->gpc['id']) )
        XF::$tpl->clear_cache('post.tpl',$this->gpc['id']);
      XF::tpl_use_cache_pool(0,'reset');
      XFUI::load_lang_res('','topic');
      $cache = XFCache::topic($this->gpc['id']);
      XFCache::topic_delta($cache,'change_lock',array('close'=>$new));
      XFCache::put('topic',$this->gpc['id'],$cache);
      $this->sucmsg = ( $new ) ? '{:topic_is_now_closed}' : '{:topic_is_now_opened}';
      $this->sucid = ( $new ) ? '{:open_topic}' : '{:close_topic}';
      $this->sucss = ( $new ) ? 'none' : 'block';
      $this->success = true;
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_lock($input){
  $a = new XFAction_post_lock();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() ){
    XFUI::$ajax_response->assign('f_post_mcp_lock_'.$b['id'],'innerHTML',XFUI::lang_str($a->sucid));
    XFUI::$ajax_response->assign('f_post_new_reply_1','style.display',$a->sucss);
    XFUI::$ajax_response->assign('f_post_new_reply_2','style.display',$a->sucss);
    return xfaf_success('',$a->sucmsg);
    }
    else
    return xfaf_failure($a->get_error());
  }

?>
