<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_edit_revert extends XFAction {
const USE_TAN = true;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
public $sucid = 0;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','mcp');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'id',0),'int');
  $this->gpc = array('revid'=>$id);
  return true;
  }

  /**
  * set another 'revision' of a posting as 'active'
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $schk = XF::sql_query("SELECT pd_p_id FROM ".XF::tbl('post_data')." WHERE pd_id = :revid",
    array('revid'=>array($this->gpc['revid'],'int')),__METHOD__,__LINE__);
    $postdata = $schk->fetchObject();
    $schk->closeCursor();
      if ( !is_object($postdata) )
      $this->error = '{:no_valid_id}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_data'=>'w','post_meta'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $u = XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_is_last = false WHERE pd_p_id = :postid",
      array('postid'=>array($postdata->pd_p_id,'int')),__METHOD__,__LINE__);
        if ( $u > 0 ){
        XF::sql_query("UPDATE ".XF::tbl('post_data')." SET pd_is_last = true WHERE pd_id = :revid AND pd_p_id = :postid",
        array('postid'=>array($postdata->pd_p_id,'int'),
        'revid'=>array($this->gpc['revid'],'int')),__METHOD__,__LINE__);
        XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_pd_id = :revid WHERE p_id = :postid",
        array('postid'=>array($postdata->pd_p_id,'int'),
        'revid'=>array($this->gpc['revid'],'int')),__METHOD__,__LINE__);
        XF::tpl_use_cache_pool($postdata->pd_p_id,'begin');
          if ( XF::$tpl->is_cached('post.tpl',$postdata->pd_p_id) )
          XF::$tpl->clear_cache('post.tpl',$postdata->pd_p_id);
        XF::tpl_use_cache_pool(0,'reset');
        XF::logger(':'.$u,'postid',$postdata->pd_p_id,'newrev',$this->gpc['revid']);
        XF::sql_transaction('commit');
        $this->sucid = $postdata->pd_p_id;
        $this->success = true;
        }
        else
        $this->error = '{:no_valid_id}';
      }
    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_edit_revert($input){
  $a = new XFAction_post_edit_revert();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('topic',array('post'=>$a->sucid),false),'{:posting_reverted}');
    else
    return xfaf_failure($a->get_error());
  }

?>