<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_forgot_password extends XFAction {
const USE_TAN = false;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','login');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $stage = XF::sanitize_var(XF::ifset('get','stage',1),'int');
  $id = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $hash = XF::sanitize_var(XF::ifset('get','hash',''),'str','okifempty,restrict');
  $this->gpc = array('stage'=>$stage,'id'=>$id,'hash'=>$hash);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('overview'),'{:no_valid_id}');
  unset($stage,$id,$hash);
    if ( $this->gpc['stage'] === 2 )
    return $this->activate();
  XFUI::ajax_init();
  XFUI::html_head('{:forgot_password}');
  XF::$tpl->display('form_forgot_password.tpl');
  XFUI::html_foot();
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $uid = XF::sanitize_var(XF::ifset($input,'f_user',''),'uid');
  $this->gpc = array('f_user'=>$uid);
  $this->markgpc = array('f_user');
  return true;
  }

  /**
  * resend a random generated password to user as requested
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $susr = XF::sql_query("SELECT u_id,u_name,u_mail FROM ".XF::tbl('user')." WHERE u_name = :username",
    array('username'=>array($this->gpc['f_user'],'str')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( !is_object($userdata) ){
      $this->error = '{:no_valid_id}';
      return false;
      }
    $sreq = XF::sql_query("SELECT COUNT(ur_hash) AS req_count FROM ".XF::tbl('user_request')."
    WHERE ur_u_id = :userid AND ur_class = 'ACTIVATE_PASSWORD'",
    array('userid'=>array($userdata->u_id,'int')),__METHOD__,__LINE__);
    $reqdata = $sreq->fetchObject();
    $sreq->closeCursor();
      if ( is_object($reqdata) && $reqdata->req_count > 0 && empty($this->error) )
      $this->error = '{:you_can_only_request_one_password}';
      if ( empty($userdata->u_mail) && empty($this->error) )
      $this->error = '{:you_specified_no_mail_address}';

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $password = XF::token(8);
      $hash = substr(sha1(uniqid(microtime(true),true).$password),mt_rand(2,23),16);
      $link = XF::link('forgot_password',array('stage'=>2,'id'=>$userdata->u_id,'hash'=>$hash),false);
      $i = XF::sql_query("INSERT INTO ".XF::tbl('user_request')." (ur_class,ur_u_id,ur_time,ur_hash,ur_data) VALUES
      ('ACTIVATE_PASSWORD',:userid,:time,:hash,:data)",
      array('userid'=>array($userdata->u_id,'int'),
      'data'=>array(XF::hash(sha1(sha1($password))),'str'),
      'hash'=>array($hash,'str'),
      'time'=>array(XF::vault_query('uts'),'int')),__METHOD__,__LINE__);
        if ( !$i )
        throw new XFE('new request could not be inserted');
      require_once(XF::vault_query('root_path').'/class.mail.php');
      $m = XFMail::send(array(
      'to'=>$userdata->u_mail,
      'subject'=>XF::get_cfg('main_title').' - '.XFUI::i18n('forgot_password'),
      'message'=>sprintf(XF::file_handler('lang/'.XF::vault_query('current_language').'/forgot_password.txt','','read,local'),
        XF::get_cfg('main_title'),
        $this->gpc['f_user'],
        round(XF::get_cfg('auth_activate_limit')/3600,0),
        $this->gpc['f_user'],
        $password,
        $link,
        XF::get_cfg('mail_from_name')
        )
      ));
        if ( !$m )
        throw new XFE('password activation mail was not sent');
      XF::logger(':'.$i,'userid',$userdata->u_id);
      XF::statistic('password_request');
      XF::sql_transaction('commit');
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

  /**
  * activate a requested password by confirmation token
  * @return boolean
  * @since 1.0.0
  */
  protected function activate(){
  XFUI::load_lang_res('','register');
    try {
    $susr = XF::sql_query("SELECT u_active,u_name,ur_time,ur_hash,ur_data FROM ".XF::tbl('user')."
    LEFT JOIN ".XF::tbl('user_request')." ON ".XF::tbl('user_request').".ur_u_id = ".XF::tbl('user').".u_id
    WHERE u_id = :id AND ur_class = 'ACTIVATE_PASSWORD'",
    array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $userdata = $susr->fetchObject();
    $susr->closeCursor();
      if ( !is_object($userdata) )
      $this->error = '{:no_valid_id}';
      else{
        if ( (bool)$userdata->u_active === false && empty($this->error) )
        $this->error = '{:inactive_account_cannot_request_password}';
        if ( $userdata->ur_time+XF::get_cfg('auth_activate_limit') < XF::vault_query('uts') && empty($this->error) )
        $this->error = '{:time_limit_exceeded}';
        if ( $userdata->ur_hash !== $this->gpc['hash'] && empty($this->error) )
        $this->error = '{:hash_not_equal}';
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('user'=>'w','user_request'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $u = XF::sql_query("UPDATE ".XF::tbl('user')." SET u_password = :password WHERE u_id = :id",
      array('id'=>array($this->gpc['id'],'int'),
      'password'=>array($userdata->ur_data,'str')),__METHOD__,__LINE__);
        if ( $u )
        XF::sql_query("DELETE FROM ".XF::tbl('user_request')." WHERE ur_u_id = :id AND ur_class = 'ACTIVATE_PASSWORD'",
        array('id'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
      XF::logger(':'.$u,'userid',$this->gpc['id'],'activate_password',XF::bool2yn((bool)$u));
      XF::statistic('password_activation');
      XF::sql_transaction('commit');
      $this->success = true;
      XFUI::html_redirect(1,XF::link('login'),'{:password_activation_success}');
      }
      else
      XFUI::html_redirect(0,XF::link('overview'),$this->error);

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_forgot_password($input){
  $a = new XFAction_forgot_password();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('login','',false),'{:password_activation_sent}');
    else
    return xfaf_failure($a->get_error());
  }

?>