/*
	This file is part of jrisk.
	
	jrisk is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	jrisk is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with jrisk; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * Created on 16-feb-2005 by Alessio Treglia
 * Copyright  2005 Alessio Treglia
 */
import java.util.Collections;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.Iterator;

/**
 * <p>Un oggetto di questo tipo viene creato all'inizio del gioco.
 * Ha il compito di distribuire, in modo casuale, un numero
 * di territori uguale per tutti i partecipanti al gioco. Se
 * avanzano uno o pi territori, li assegna ai giocatori
 * partendo dall'alto della lista.</p>
 *
 * @author Alessio Treglia
 * @version 1.0.0
 */
 
public class DistributoreTerritori {
    /** Tabellone di gioco */
    private Tabellone planisfero;
    
    /**
     * Inizializza l'oggetto.
     * 
     * @param planisfero riferimento al <code>Tabellone</code> di gioco
     */
    public DistributoreTerritori(Tabellone planisfero) {
        this.planisfero = planisfero;
    }
    
    /**
     * Assegna i singoli territori partendo dall'alto della
     * lista (il giocatore che ha fatto il numero pi alto sar
     * il primo a giocare e dunque anche il primo a ricevere un
     * territorio).
     * 
     * @param giocatori elenco di partecipanti al gioco
     */
    public void assegnaCasualmente(List giocatori) {
        List territori;								// Elenco dei territori
        Giocatore g;								// Riferimento ad un Giocatore
        Territorio territorio;						// Territorio da assegnare
        String nome;								// Nome territorio temporaneo
        Iterator it;								// Iteratore
        int i;										// Contatore
        
        /** Riceve la lista dei territori dalla classe ElencoTerritoriContinenti */
        territori = new ArrayList(Arrays.asList(ElencoTerritoriContinenti.TERRITORI));
        /** "mischia" i Territori */
        Collections.shuffle(territori);
        
        i = 0;										// Inizializza cursore dei giocatori
        it = territori.iterator();					// Inizializza l'iteratore dei territori
        
        /*
         * Assegna ogni territorio ad un giocatore diverso
         */
        while(it.hasNext()) {
            /* Riceve il nome dalla lista dei nomi dei territori */
            nome = (String) it.next();
            /* Riceve il giocatore dalla lista dei giocatori */
            g = (Giocatore) giocatori.get(i);
            territorio = new Territorio(nome, 1);	// Crea un nuovo Territorio
            /* Imposta il corretto continente per il territorio corrente */
            territorio.setContinente(ElencoTerritoriContinenti.getContinente(nome));
            /* Aggiunge il territorio fra quelli posseduti dal giocatore */
            g.aggiungiTerritorio(territorio);
            /* Aggiorna il tabellone di gioco */
            planisfero.aggiungi(territorio,g);
            /* Se il giocatore  l'ultimo in lista */
            if( i == (giocatori.size()-1) )
                i = 0;								// Riposiziona il cursore in cima alla lista
            else
                i++;								// sposta il cursore all'elemento successivo
        }
    }
    /**
     * Imposta i confini per i territori posseduti dai
     * giocatori della collezione.
     * 
     * @param giocatori <code>List</code> di oggetti 
     * <code>Giocatore</code>
     */
    public void impostaConfini(List giocatori) {
        Set territoriDelGiocatore;					// Collezione di territori del giocatore corrente
        Giocatore g;								// Giocatore corrente
        Territorio t;								// Territorio corrente
        Territorio u;								// Primo in lista
        Iterator it, jt;							// Iteratori per le liste dei giocatori e dei
        											// territori di ogni giocatore

        
        it = giocatori.iterator();					// Inizializza l'iteratore della lista dei giocatori
        /*
        while(kt.hasNext()) {						// Scorro la lista dei giocatori
            g = (Giocatore) kt.next();				// prende il giocatore corrente
            territoriDelGiocatore = g.getTerritori();// prende i territori occupati da esso
            it = territoriDelGiocatore.iterator();	// Inizializza l'iteratore della lista dei territori
            jt = territoriDelGiocatore.iterator();
            
            while(it.hasNext()) {
                t = (Territorio)it.next();
                while(jt.hasNext()) {
                    u = (Territorio)jt.next();
                    if(u != t)
                        planisfero.setConfinanti(t.getNome(),u.getNome());
                }
            }
        }*/
        while(it.hasNext()) {
            g = (Giocatore) it.next();
            territoriDelGiocatore = g.getTerritori();
            jt = territoriDelGiocatore.iterator();
            while(jt.hasNext()) {
                t = (Territorio) jt.next();
                planisfero.setConfinantiLista(t.getNome(),GestoreConfini.confinaCon(t));
                //t.setConfinanti(planisfero.setConfinantiLista(t.getNome(),GestoreConfini.confinaCon(t)));
            }
        }
        
    }
}
