/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DistributoreTerritori {
    private Tabellone planisfero;

    public DistributoreTerritori(Tabellone planisfero) {
        this.planisfero = planisfero;
    }

    public void assegnaCasualmente(List giocatori) {
        ArrayList<String> territori = new ArrayList<String>(Arrays.asList(ElencoTerritoriContinenti.TERRITORI));
        Collections.shuffle(territori);
        int i = 0;
        Iterator it = territori.iterator();
        while (it.hasNext()) {
            String nome = (String)it.next();
            Giocatore g = (Giocatore)giocatori.get(i);
            Territorio territorio = new Territorio(nome, 1);
            territorio.setContinente(ElencoTerritoriContinenti.getContinente(nome));
            g.aggiungiTerritorio(territorio);
            this.planisfero.aggiungi(territorio, g);
            if (i == giocatori.size() - 1) {
                i = 0;
                continue;
            }
            ++i;
        }
    }

    public void impostaConfini(List giocatori) {
        Iterator it = giocatori.iterator();
        while (it.hasNext()) {
            Giocatore g = (Giocatore)it.next();
            Set territoriDelGiocatore = g.getTerritori();
            Iterator jt = territoriDelGiocatore.iterator();
            while (jt.hasNext()) {
                Territorio t = (Territorio)jt.next();
                this.planisfero.setConfinantiLista(t.getNome(), GestoreConfini.confinaCon(t));
            }
        }
    }
}

