/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import net.sourceforge.jnlp.config.ValueValidator;
import net.sourceforge.jnlp.runtime.Translator;

public class BasicValueValidators {
    public static ValueValidator getBooleanValidator() {
        return new BooleanValidator();
    }

    public static ValueValidator getFilePathValidator() {
        return new FilePathValidator();
    }

    public static ValueValidator getRangedIntegerValidator(int low, int high) {
        return new RangedIntegerValidator(low, high);
    }

    public static ValueValidator getStringValidator(String[] validValues) {
        return new StringValueValidator(validValues);
    }

    public static ValueValidator getUrlValidator() {
        return new UrlValidator();
    }

    private static class UrlValidator
    implements ValueValidator {
        private UrlValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            if (value == null) {
                return;
            }
            try {
                new URL((String)value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleUrlValues");
        }
    }

    private static class StringValueValidator
    implements ValueValidator {
        String[] options = null;

        public StringValueValidator(String[] acceptableOptions) {
            this.options = acceptableOptions;
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            Object possibleValue = value;
            if (!(possibleValue instanceof String)) {
                throw new IllegalArgumentException("Must be a string");
            }
            String stringVal = (String)possibleValue;
            boolean found = false;
            for (String knownVal : this.options) {
                if (!knownVal.equals(stringVal)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Arrays.toString(this.options);
        }
    }

    private static class RangedIntegerValidator
    implements ValueValidator {
        private int low = 0;
        private int high = 0;

        public RangedIntegerValidator(int low, int high) {
            this.low = low;
            this.high = high;
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            long actualValue;
            block6: {
                Object possibleValue = value;
                actualValue = 0L;
                try {
                    if (possibleValue instanceof String) {
                        actualValue = Long.valueOf((String)possibleValue);
                        break block6;
                    }
                    if (possibleValue instanceof Integer) {
                        actualValue = ((Integer)possibleValue).intValue();
                        break block6;
                    }
                    if (possibleValue instanceof Long) {
                        actualValue = (Long)possibleValue;
                        break block6;
                    }
                    throw new IllegalArgumentException("Must be an integer");
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Must be an integer");
                }
            }
            if (actualValue < (long)this.low || actualValue > (long)this.high) {
                throw new IllegalArgumentException("Not in range from " + this.low + " to " + this.high);
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleRangedIntegerValues", this.low, this.high);
        }
    }

    private static class FilePathValidator
    implements ValueValidator {
        private FilePathValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            if (value == null) {
                return;
            }
            Object possibleValue = value;
            if (!(possibleValue instanceof String)) {
                throw new IllegalArgumentException();
            }
            String possibleFile = (String)possibleValue;
            if (!possibleFile.startsWith("/")) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleFileValues");
        }
    }

    private static class BooleanValidator
    implements ValueValidator {
        private BooleanValidator() {
        }

        @Override
        public void validate(Object value) throws IllegalArgumentException {
            String lower;
            Object possibleValue = value;
            if (possibleValue instanceof String && ((lower = ((String)possibleValue).toLowerCase(Locale.ENGLISH)).equals(Boolean.TRUE.toString()) || lower.equals(Boolean.FALSE.toString()))) {
                possibleValue = Boolean.valueOf(lower);
            }
            if (!(possibleValue instanceof Boolean)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getPossibleValues() {
            return Translator.R("VVPossibleBooleanValues", Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }
}

