/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.chooser.RdiffFile;
import ch.fhnw.jbackpack.chooser.RdiffFileSystemView;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

public class RdiffFileView
extends FileView {
    private static final Logger LOGGER = Logger.getLogger(RdiffFileView.class.getName());

    public String getDescription(File f) {
        LOGGER.log(Level.INFO, "no description for {0}", f);
        return null;
    }

    public Icon getIcon(File f) {
        Icon icon = null;
        icon = f.getParentFile() == null ? IconManager.HARD_DRIVE_ICON : (f.isDirectory() ? IconManager.DIRECTORY_ICON : IconManager.FILE_ICON);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "icon for {0}: {1}", new Object[]{f, icon});
        }
        return icon;
    }

    public String getName(File f) {
        String name = null;
        name = f.getParentFile() == null && f instanceof RdiffFile ? RdiffFileSystemView.getRootName((RdiffFile)f) : f.getName();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "name of {0} is {1}", new Object[]{f, name});
        }
        return name;
    }

    public String getTypeDescription(File f) {
        LOGGER.log(Level.INFO, "no type description for {0}", f);
        return null;
    }

    public Boolean isTraversable(File f) {
        boolean isTraversable = f.isDirectory();
        if (LOGGER.isLoggable(Level.FINER)) {
            if (isTraversable) {
                LOGGER.log(Level.FINER, "{0} is traversable", f);
            } else {
                LOGGER.log(Level.FINER, "{0} is NOT traversable", f);
            }
        }
        return isTraversable;
    }
}

