/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.jbackpack.chooser.RdiffFileDatabase;
import ch.fhnw.util.CurrentOperatingSystem;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdiffFile
extends File {
    private static final Logger LOGGER = Logger.getLogger(RdiffFile.class.getName());
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Increment increment;
    private final RdiffFile parent;
    private final String absolutePath;
    private final String name;
    private final long fileSize;
    private final boolean directory;
    private final RdiffFileDatabase rdiffFileDatabase;
    private long modTime;

    public RdiffFile(RdiffFileDatabase rdiffFileDatabase, Increment increment, RdiffFile parent, String name, long length, long modTime, boolean directory) {
        super(parent, name);
        this.rdiffFileDatabase = rdiffFileDatabase;
        this.increment = increment;
        this.parent = parent;
        this.name = name;
        this.fileSize = length;
        this.modTime = modTime;
        this.directory = directory;
        if (parent == null) {
            this.absolutePath = name = ".";
        } else if (parent.getParentFile() == null) {
            this.absolutePath = name;
        } else {
            String parentPath = parent.getPath();
            this.absolutePath = parentPath + separatorChar + name;
        }
    }

    @Override
    public boolean canExecute() {
        LOGGER.log(Level.INFO, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public boolean canRead() {
        LOGGER.log(Level.INFO, "{0}: returning true", this.absolutePath);
        return true;
    }

    @Override
    public boolean canWrite() {
        LOGGER.log(Level.FINEST, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public int compareTo(File file) {
        int returnValue = this.absolutePath.compareTo(file.getPath());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "{0} compareTo({1}) = {2}", new Object[]{this.absolutePath, file, returnValue});
        }
        return returnValue;
    }

    @Override
    public boolean createNewFile() throws IOException {
        throw new IOException("can not alter rdiff-backup directories");
    }

    @Override
    public boolean delete() {
        LOGGER.log(Level.INFO, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public void deleteOnExit() {
        LOGGER.log(Level.INFO, "{0}: impossible", this.absolutePath);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            LOGGER.log(Level.FINEST, "{0} is the same object", obj);
            return true;
        }
        if (obj == null) {
            LOGGER.log(Level.FINEST, "{0}: other object is null", this.absolutePath);
            return false;
        }
        Class<?> otherClass = obj.getClass();
        if (this.getClass() != otherClass) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "{0}: {1} is of class {2}", new Object[]{this.absolutePath, obj, otherClass.getName()});
            }
            return false;
        }
        RdiffFile other = (RdiffFile)obj;
        if (!(this.increment == other.increment || this.increment != null && this.increment.equals(other.increment))) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "{0}: {1} is of other incrememt", new Object[]{this.absolutePath, obj});
            }
            return false;
        }
        if (this.absolutePath == null ? other.absolutePath != null : !RdiffFile.canonicalize(this.absolutePath).equals(RdiffFile.canonicalize(other.absolutePath))) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "{0}: {1} has other path ({2})", new Object[]{this.absolutePath, obj, other.absolutePath});
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean exists() {
        LOGGER.log(Level.FINEST, "{0}: returning true", this.absolutePath);
        return true;
    }

    @Override
    public File getAbsoluteFile() {
        LOGGER.log(Level.INFO, "{0}: returning this", this.absolutePath);
        return this;
    }

    @Override
    public String getAbsolutePath() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, this.absolutePath});
        }
        return this.absolutePath;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        RdiffFile tmp;
        String canonicalPath = this.getCanonicalPath();
        RdiffFile root = this;
        while ((tmp = root.getParentRdiffFile()) != null) {
            root = tmp;
        }
        RdiffFile canonicalFile = root.getChild(canonicalPath);
        if (canonicalFile == null) {
            canonicalFile = this;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning {1}", new Object[]{this.absolutePath, canonicalFile});
        }
        return canonicalFile;
    }

    public static String canonicalize(String path) {
        int index;
        String trailingDot;
        String pattern = Pattern.quote(separatorChar + "." + separatorChar);
        if ((path = path.replaceAll(pattern, Matcher.quoteReplacement(separator))).endsWith(trailingDot = separatorChar + ".")) {
            path = path.substring(0, path.length() - trailingDot.length());
        }
        String doubleDot = separatorChar + ".." + separatorChar;
        while ((index = path.indexOf(doubleDot)) != -1) {
            String prefix = "";
            int previousSeparatorIndex = path.lastIndexOf(separatorChar, index - 1);
            if (previousSeparatorIndex != -1) {
                prefix = path.substring(0, previousSeparatorIndex + 1);
            }
            String postfix = path.substring(index + doubleDot.length());
            path = prefix + postfix;
        }
        String trailingDoubleDot = separatorChar + "..";
        if (path.endsWith(trailingDoubleDot)) {
            int previousSeparatorIndex = path.lastIndexOf(separatorChar, path.length() - trailingDoubleDot.length() - 1);
            path = previousSeparatorIndex < 1 ? separator : path.substring(0, previousSeparatorIndex);
        }
        return path;
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return RdiffFile.canonicalize(this.absolutePath);
    }

    @Override
    public long getFreeSpace() {
        LOGGER.log(Level.INFO, "{0}: returning 0", this.absolutePath);
        return 0L;
    }

    @Override
    public String getName() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, this.name});
        }
        return this.name;
    }

    @Override
    public String getParent() {
        String parentPath;
        String string = parentPath = this.parent == null ? null : this.parent.getPath();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, parentPath});
        }
        return parentPath;
    }

    @Override
    public File getParentFile() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, this.parent});
        }
        return this.parent;
    }

    @Override
    public String getPath() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, this.absolutePath});
        }
        return this.absolutePath;
    }

    @Override
    public long getTotalSpace() {
        LOGGER.log(Level.INFO, "{0}: returning 0", this.absolutePath);
        return 0L;
    }

    @Override
    public long getUsableSpace() {
        LOGGER.log(Level.INFO, "{0}: returning 0", this.absolutePath);
        return 0L;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.increment == null ? 0 : this.increment.hashCode());
        hash = 71 * hash + (this.absolutePath == null ? 0 : this.absolutePath.hashCode());
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0}: returning {1}", new Object[]{this.absolutePath, hash});
        }
        return hash;
    }

    @Override
    public boolean isAbsolute() {
        LOGGER.log(Level.FINEST, "{0}: returning true", this.absolutePath);
        return true;
    }

    @Override
    public boolean isDirectory() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            if (this.directory) {
                LOGGER.log(Level.FINEST, "{0} is a directory", this.absolutePath);
            } else {
                LOGGER.log(Level.FINEST, "{0} is NOT a directory", this.absolutePath);
            }
        }
        return this.directory;
    }

    @Override
    public boolean isFile() {
        boolean isFile;
        boolean bl = isFile = !this.isDirectory();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0}: returning {1}", new Object[]{this.absolutePath, isFile});
        }
        return isFile;
    }

    @Override
    public boolean isHidden() {
        boolean hidden = false;
        switch (CurrentOperatingSystem.OS) {
            case Linux: 
            case Mac_OS_X: {
                boolean bl = hidden = this.name.length() > 0 && this.name.charAt(0) == '.';
            }
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "{0}: returning {1}", new Object[]{this.absolutePath, hidden});
        }
        return hidden;
    }

    @Override
    public long lastModified() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning {1}", new Object[]{this.absolutePath, this.modTime});
        }
        return this.modTime;
    }

    @Override
    public long length() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0}: returning {1}", new Object[]{this.absolutePath, this.fileSize});
        }
        return this.fileSize;
    }

    @Override
    public String[] list() {
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        int childrenCount = children.size();
        String[] childrenNames = new String[childrenCount];
        int i = 0;
        for (RdiffFile child : children) {
            childrenNames[i++] = child.getPath();
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            String names = RdiffFile.stringArrayToString(childrenNames, "\t");
            LOGGER.log(Level.INFO, "{0}: returning{1}{2}", new Object[]{this.absolutePath, LINE_SEPARATOR, names});
        }
        return childrenNames;
    }

    @Override
    public String[] list(FilenameFilter filter) {
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        if (filter == null) {
            LOGGER.log(Level.INFO, "{0}: no filter", this.absolutePath);
            return this.list();
        }
        ArrayList<String> acceptedNames = new ArrayList<String>();
        for (RdiffFile child : children) {
            String childName = child.getName();
            if (!filter.accept(this, childName)) continue;
            acceptedNames.add(childName);
        }
        String[] namesArray = acceptedNames.toArray(new String[acceptedNames.size()]);
        if (LOGGER.isLoggable(Level.INFO)) {
            String names = RdiffFile.stringArrayToString(namesArray, "\t");
            LOGGER.log(Level.INFO, "{0}: returning{1}{2}", new Object[]{this.absolutePath, LINE_SEPARATOR, names});
        }
        return namesArray;
    }

    @Override
    public File[] listFiles() {
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        if (LOGGER.isLoggable(Level.FINER)) {
            String fileList = RdiffFile.fileListToString(children, "\t");
            LOGGER.log(Level.FINER, "{0}: returning {1}{2}", new Object[]{this.absolutePath, LINE_SEPARATOR, fileList});
        }
        return children.toArray(new File[children.size()]);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        if (filter == null) {
            LOGGER.log(Level.FINE, "{0}: no filter", this.absolutePath);
            return this.listFiles();
        }
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        ArrayList<RdiffFile> acceptedFiles = new ArrayList<RdiffFile>();
        for (RdiffFile child : children) {
            if (!filter.accept(this, child.getName())) continue;
            acceptedFiles.add(child);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            String fileList = RdiffFile.fileListToString(acceptedFiles, "\t");
            LOGGER.log(Level.FINE, "{0}: returning {1}{2}", new Object[]{this.absolutePath, LINE_SEPARATOR, fileList});
        }
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    @Override
    public File[] listFiles(FileFilter filter) {
        if (filter == null) {
            LOGGER.log(Level.FINE, "{0}: no filter", this.absolutePath);
            return this.listFiles();
        }
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        ArrayList<RdiffFile> acceptedFiles = new ArrayList<RdiffFile>();
        for (RdiffFile child : children) {
            if (!filter.accept(child)) continue;
            acceptedFiles.add(child);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            String fileList = RdiffFile.fileListToString(acceptedFiles, "\t");
            LOGGER.log(Level.FINE, "{0}: returning {1}{2}", new Object[]{this.absolutePath, LINE_SEPARATOR, fileList});
        }
        return acceptedFiles.toArray(new File[acceptedFiles.size()]);
    }

    @Override
    public boolean mkdir() {
        LOGGER.log(Level.INFO, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public boolean mkdirs() {
        LOGGER.log(Level.INFO, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public boolean renameTo(File dest) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0}: can not rename to {1}, returning false", new Object[]{this.absolutePath, dest});
        }
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setExecutable({1},{2}): returning false", new Object[]{this.absolutePath, executable, ownerOnly});
        }
        return false;
    }

    @Override
    public boolean setExecutable(boolean executable) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setExecutable({1}): returning false", new Object[]{this.absolutePath, executable});
        }
        return false;
    }

    @Override
    public boolean setLastModified(long time) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} setLastModified({1})", new Object[]{this.absolutePath, time});
        }
        this.modTime = time;
        return true;
    }

    @Override
    public boolean setReadOnly() {
        LOGGER.log(Level.INFO, "{0}: returning false", this.absolutePath);
        return false;
    }

    @Override
    public boolean setReadable(boolean readable, boolean ownerOnly) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setReadable({1},{2}): returning false", new Object[]{this.absolutePath, readable, ownerOnly});
        }
        return false;
    }

    @Override
    public boolean setReadable(boolean readable) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setReadable({1}): returning false", new Object[]{this.absolutePath, readable});
        }
        return false;
    }

    @Override
    public boolean setWritable(boolean writable, boolean ownerOnly) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setWritable({1},{2}): returning false", new Object[]{this.absolutePath, writable, ownerOnly});
        }
        return false;
    }

    @Override
    public boolean setWritable(boolean writable) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0} setWritable({1}): returning false", new Object[]{this.absolutePath, writable});
        }
        return false;
    }

    @Override
    public String toString() {
        return this.absolutePath;
    }

    @Override
    public URI toURI() {
        URI uri = super.toURI();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, uri});
        }
        return uri;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        URL url = super.toURL();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "{0}: returning \"{1}\"", new Object[]{this.absolutePath, url});
        }
        return url;
    }

    public Increment getIncrement() {
        return this.increment;
    }

    public RdiffFile getDotDirectory() throws IOException {
        return new RdiffFile(this.rdiffFileDatabase, this.increment, this.parent, ".", this.fileSize, this.modTime, this.directory);
    }

    public RdiffFile getDotDotDirectory() throws IOException {
        if (this.parent == null) {
            return new RdiffFile(this.rdiffFileDatabase, this.increment, null, "..", 0L, this.modTime, true);
        }
        return new RdiffFile(this.rdiffFileDatabase, this.increment, this, "..", 0L, this.parent.lastModified(), true);
    }

    public RdiffFile getParentRdiffFile() {
        return this.parent;
    }

    public File getLongestMatch(String path) throws IOException {
        RdiffFile foundChild;
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        String wantedChild = path;
        int separatorIndex = path.indexOf(separatorChar);
        if (separatorIndex != -1) {
            wantedChild = path.substring(0, separatorIndex);
        }
        if ((foundChild = this.findChild(children, wantedChild)) == null) {
            LOGGER.log(Level.FINE, "{0}: returning this", this.absolutePath);
            return this;
        }
        return foundChild.getLongestMatch(path.substring(separatorIndex + 1));
    }

    private static String stringArrayToString(String[] strings, String indentation) {
        StringBuilder stringBuilder = new StringBuilder();
        int length = strings.length;
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(indentation);
            stringBuilder.append(strings[i]);
            if (i >= length - 1) continue;
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    private static String fileListToString(Collection<RdiffFile> files, String indentation) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RdiffFile file : files) {
            stringBuilder.append(indentation);
            stringBuilder.append(file.getName());
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public RdiffFile getChild(String path) throws IOException {
        LOGGER.log(Level.FINE, "path: \"{0}\"", path);
        if (path.equals(this.absolutePath)) {
            return this;
        }
        List<RdiffFile> children = this.rdiffFileDatabase.listFiles(this.increment, this);
        int separatorIndex = path.indexOf(separatorChar);
        if (separatorIndex == -1) {
            return this.findChild(children, path);
        }
        String childName = path.substring(0, separatorIndex);
        RdiffFile child = this.findChild(children, childName);
        if (child == null) {
            return null;
        }
        return child.getChild(path.substring(separatorIndex + 1));
    }

    private RdiffFile findChild(List<RdiffFile> children, String name) {
        if (children != null) {
            for (RdiffFile child : children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }
}

