/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack.chooser;

import ch.fhnw.jbackpack.chooser.Increment;
import ch.fhnw.util.FileTools;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class IncrementsListCellRenderer
extends DefaultListCellRenderer {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final Icon MIRROR_ICON = new ImageIcon(IncrementsListCellRenderer.class.getResource("/ch/fhnw/jbackpack/icons/16x16/hdd_unmount.png"));
    private static final Icon INCREMENT_ICON = new ImageIcon(IncrementsListCellRenderer.class.getResource("/ch/fhnw/jbackpack/icons/16x16/up.png"));

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Increment) {
            Increment increment = (Increment)value;
            String text = DATE_FORMAT.format(increment.getTimestamp());
            if (increment.getSize() == null) {
                this.setText(text);
            } else {
                String sizeString = FileTools.getDataVolumeString(increment.getSize(), 1);
                this.setText(text + " (" + sizeString + ')');
            }
            this.setIcon(index == 0 ? MIRROR_ICON : INCREMENT_ICON);
        }
        return this;
    }
}

