/*
 * Decompiled with CFR 0.152.
 */
package ch.fhnw.jbackpack;

import ch.fhnw.jbackpack.DownloadSwingWorker;
import ch.fhnw.jbackpack.IconManager;
import ch.fhnw.jbackpack.JBackpack;
import ch.fhnw.util.FileTools;
import ch.fhnw.util.FileTransferable;
import ch.fhnw.util.ProcessExecutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class WindowsSetupHelpFrame
extends JFrame {
    private static final Logger LOGGER = Logger.getLogger(WindowsSetupHelpFrame.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
    private static final File HOME_DIR = new File(System.getProperty("user.home"));
    private JLabel adminRightsLabel;
    private JPanel buttonPanel;
    private JLabel errorlabel;
    private JButton exitButton;
    private JButton installMSButton;
    private JButton installRdiffbackupButton;
    private JLabel msLabel;
    private JButton restartButton;

    public WindowsSetupHelpFrame() {
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.errorlabel = new JLabel();
        this.adminRightsLabel = new JLabel();
        this.installRdiffbackupButton = new JButton();
        this.msLabel = new JLabel();
        this.installMSButton = new JButton();
        this.buttonPanel = new JPanel();
        this.restartButton = new JButton();
        this.exitButton = new JButton();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("ch/fhnw/jbackpack/Strings");
        this.setTitle(bundle.getString("WindowsSetupHelpFrame.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.errorlabel.setIcon(IconManager.ERROR_ICON);
        this.errorlabel.setText(bundle.getString("WindowsSetupHelpDialog.errorlabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.errorlabel, gridBagConstraints);
        this.adminRightsLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        this.adminRightsLabel.setText(bundle.getString("WindowsSetupHelpFrame.adminRightsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.adminRightsLabel, gridBagConstraints);
        this.installRdiffbackupButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/download_manager.png")));
        this.installRdiffbackupButton.setText(bundle.getString("WindowsSetupHelpDialog.installRdiffbackupButton.text"));
        this.installRdiffbackupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowsSetupHelpFrame.this.installRdiffbackupButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 15, 0, 10);
        this.getContentPane().add((Component)this.installRdiffbackupButton, gridBagConstraints);
        this.msLabel.setText(bundle.getString("WindowsSetupHelpDialog.msLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 15, 0, 15);
        this.getContentPane().add((Component)this.msLabel, gridBagConstraints);
        this.installMSButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/download_manager.png")));
        this.installMSButton.setText(bundle.getString("WindowsSetupHelpDialog.installMSButton.text"));
        this.installMSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowsSetupHelpFrame.this.installMSButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 10);
        this.getContentPane().add((Component)this.installMSButton, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.restartButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/reload.png")));
        this.restartButton.setText(bundle.getString("WindowsSetupHelpDialog.restartButton.text"));
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowsSetupHelpFrame.this.restartButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 10, 5);
        this.buttonPanel.add((Component)this.restartButton, gridBagConstraints);
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("/ch/fhnw/jbackpack/icons/16x16/exit.png")));
        this.exitButton.setText(bundle.getString("WindowsSetupHelpDialog.exitButton.text"));
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WindowsSetupHelpFrame.this.exitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 10, 0);
        this.buttonPanel.add((Component)this.exitButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void installMSButtonActionPerformed(ActionEvent evt) {
        final File exeFile = new File(HOME_DIR, "vcredist_x86.exe");
        LOGGER.log(Level.INFO, "downloading to {0}", exeFile);
        try {
            URL url = new URL("http://download.microsoft.com/download/d/d/9/dd9a82d0-52ef-40db-8dab-795376989c03/vcredist_x86.exe");
            final DownloadSwingWorker downloadSwingWorker = new DownloadSwingWorker(this, url, "Microsoft Visual C++ 2008 Redistributable Package", exeFile);
            downloadSwingWorker.execute();
            new Thread(){

                public void run() {
                    try {
                        if (((Boolean)downloadSwingWorker.get()).booleanValue()) {
                            ProcessExecutor processExecutor = new ProcessExecutor();
                            processExecutor.executeProcess(exeFile.getPath());
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }.start();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void installRdiffbackupButtonActionPerformed(ActionEvent evt) {
        final File win32File = new File(HOME_DIR, "rdiff-backup-1.2.8-win32.zip");
        LOGGER.log(Level.INFO, "downloading to {0}", win32File);
        String description = "rdiff-backup";
        try {
            URL url = new URL("http://savannah.nongnu.org/download/rdiff-backup/rdiff-backup-1.2.8-win32.zip");
            final DownloadSwingWorker downloadSwingWorker = new DownloadSwingWorker(this, url, "rdiff-backup", win32File);
            downloadSwingWorker.execute();
            new Thread(){

                public void run() {
                    try {
                        if (((Boolean)downloadSwingWorker.get()).booleanValue()) {
                            WindowsSetupHelpFrame.this.unpackAndCopy(win32File, "rdiff-backup");
                        } else {
                            String errorMessage = BUNDLE.getString("Downloading_Failed");
                            errorMessage = MessageFormat.format(errorMessage, "rdiff-backup", downloadSwingWorker.getIoException());
                            JOptionPane.showMessageDialog(WindowsSetupHelpFrame.this, errorMessage, BUNDLE.getString("Error"), 0);
                        }
                    }
                    catch (InterruptedException ex) {
                        WindowsSetupHelpFrame.this.rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    catch (ExecutionException ex) {
                        WindowsSetupHelpFrame.this.rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        WindowsSetupHelpFrame.this.rdiffBackupInstallationFailed();
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                }
            }.start();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private void restartButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        JBackpack.systemCheck();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        System.exit(-1);
    }

    private void unpackAndCopy(File win32File, String description) throws IOException {
        String osName = System.getProperty("os.name");
        String system32Path = "C:\\Windows\\System32";
        if ("Windows XP".equals(osName)) {
            this.unpack(win32File, new File(system32Path));
            String infoMessage = BUNDLE.getString("Installation_Finished");
            infoMessage = MessageFormat.format(infoMessage, description);
            JOptionPane.showMessageDialog(this, infoMessage, BUNDLE.getString("Information"), 1);
        } else {
            File tempDir = FileTools.createTempDirectory("jbackpack", null);
            this.unpack(win32File, tempDir);
            File tempFile = new File(tempDir, "rdiff-backup.exe");
            FileTransferable.copy(tempFile);
            JOptionPane.showMessageDialog(this, BUNDLE.getString("Windows_Manual_Copy_Info"), BUNDLE.getString("Information"), 1);
            ProcessExecutor processExecutor = new ProcessExecutor();
            processExecutor.executeProcess("explorer.exe", system32Path);
        }
    }

    private void unpack(File win32File, File destinationDir) throws IOException {
        ZipFile zipFile = new ZipFile(win32File);
        ZipEntry entry = zipFile.getEntry("rdiff-backup-1.2.8/rdiff-backup.exe");
        InputStream inputStream = zipFile.getInputStream(entry);
        File target = new File(destinationDir, "rdiff-backup.exe");
        FileOutputStream fileOutputStream = new FileOutputStream(target);
        byte[] buffer = new byte[1024];
        int count = inputStream.read(buffer);
        while (count != -1) {
            fileOutputStream.write(buffer, 0, count);
            count = inputStream.read(buffer);
        }
        inputStream.close();
        fileOutputStream.close();
    }

    private void rdiffBackupInstallationFailed() {
        JOptionPane.showMessageDialog(this, BUNDLE.getString("RdiffBackup_Installation_Failed"), BUNDLE.getString("Error"), 0);
    }
}

