<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "config/config_igloo.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";


// SETUP ERROR HANDLING -----------------------------------------------------------------------
// this is accessed and updated with all errors thoughtout this build
// processing regularly checks if empty before continuing
$GLOBALS['igloo_error_log'] = array();


// SETUP DATABASE -----------------------------------------------------------------------
require_once('class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
if (!$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db'])) {
	header("Location: error.php?error=1");
	exit;
}
$db->prefix = $c_node['db']['prefix'];


//SETUP DATE -----------------------------------------------------------------------
require_once('class/Date.class.php');
$date = new Date();


// START SESSION --------------------------------------------------------------
session_name($c_node['node']['php_session_name']);
session_start();


// SETUP USER -----------------------------------------------------------------------
require_once('class/User.class.php');
$user = new User($db, $date);
$user->relation_type = $c_node['user']['relation_type']['approved']; //not sure we need this - tom 7th dec 2004
$user->status_ids = $c_node['user']['status'];
$user->language_arr = $c_node['node']['language'];

if(!empty($_SESSION['s_md5'])) {
	//authenticate user
	$user->authUser();
	
	$me = $_SESSION;
	$me['user_id'] = $me['s_user_id'];
	$me['role_id'] = $me['s_role_id'];
	
	
	//SETUP USER MESSAGES ------------------------------------------------------
	require_once('class/IM.class.php');
	$im = new IM($me['user_id'], $db, $c_node['messaging']['message_box_max_size']);
	// Setting the message status coding
	$im->setStatus($c_node['messaging']['message_status_unread'], $c_node['messaging']['message_status_read']);
	$im->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
	//get inbox unread message count
	$me['mail'] = $im->messageCount();
	
	$rsp_level_id = $c_node['rsp']['rsp_level']['node'];
}
else { //treat as public
	$me['role_id'] = $c_node['arr_acs']['node_role_visitor'];;
	$me['language_id'] = $c_node['node']['language']['default'];
	$me['template_id'] = $c_node['node']['template_default_name'];
	
	if(empty($_SESSION['language_ids'])) {
		$_SESSION['breadcrumb'] = 			array();
		$_SESSION['language_ids'] = 		array();
		$_SESSION['user_homepage'] = 		$c_node['node']['page_default'];
		
		if (!empty($c_node['node']['language']['pack'])) {
			foreach($c_node['node']['language']['pack'] as $key => $i):
				$me['language_ids'][] = $key;
			endforeach;
		}
	}
		
	$me['breadcrumb'] = 			$_SESSION['breadcrumb'];
	$me['language_ids'] = 			$_SESSION['language_ids'];
	$me['user_homepage'] = 			$_SESSION['user_homepage'];
	
	$rsp_level_id = $c_node['rsp']['rsp_level']['public'];
	
	//we check to see if we received an rss feed
	if (isset($_REQUEST['feed'])) {
		if ($user->checkFeedPassword($_REQUEST['feed'])) {
			$rsp_level_id = $c_node['rsp']['rsp_level']['node'];
			$rss_access_granted = 1;
		}
	}
}


// SETUP UP USER ACS -------------------------------------------------------
require_once('class/Acs.class.php');
$user_acs = new Acs($me['role_id'], $db);


//SETUP SHOUT -----------------------------------------------------------------------
require_once('class/Shout.class.php');
$shout = new Shout($db, $date);
$shoutbox = $shout->getShout();


//SETUP FILE -----------------------------------------------------------------------
require_once('class/File.class.php');
$file = new File($db, null, $c_node['file'], $c_node['dir']);
$file->config_ids = $c_node['file'];


// SETUP TEMPLATE -------------------------------------------------------------------
$template_path = "template/";

if (isset($me['template_id'])) {
    $template_name = $me['template_id'];
}
else {
	$template_name = $c_node['node']['template_default_name'];
}

$template_path = $template_path . $template_name . "/";

require_once('class/Template.class.php');
$tpl = & new Template($template_path); // This is the outter template
$tpl->date = $date;
$body = & new Template($template_path); // This is the inner template
$body->date = $date;
$page_name_full = basename($_SERVER['REQUEST_URI']);
$page_name = explode(".",$page_name_full);

// SETUP LANGUAGE -----------------------------------------------------------
if (!isset($me['user_id']) || $me['user_id'] < 1) {
	if (isset($_REQUEST['language_id'])) {
		$_SESSION['language_id'] = $_REQUEST['language_id'];
	}
	
	if (isset($_SESSION['language_id'])) {
		$me['language_id'] = $_SESSION['language_id'];
	}
}

$languagePath = "language/" . $me['language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "arrays/";
$languageTextPath = $languagePath . "texts/";
require_once($languageArrayPath . 'arr_error.lang.php');
require_once($languagePath . $page_name[0] .'.lang.php');


// RETREIVE FORM VARS ------------------------------------------------------
if (isset($_POST)) {
	$frmdata = $_POST;
}

// DICTIONARY ---------------------------------------------------------------
// Is the config set to allow spell checking?
if (!empty($c_node['node']['language']['aspell']['command'])) {
    $body->set('allow_spellcheck', 1);
}


// SETUP LOGGING ---------------------------------------------------
$GLOBALS['igloo_log'] = $c_node['log'];

//display languages if not logged in
if (!isset($me['user_id']) || $me['user_id'] < 1) {
	require_once($languageArrayPath . 'arr_language_name.lang.php');
}


// COMMENT VIEW ---------------------------------------------------
if (isset($me['user_id'])) {
	if (isset($_REQUEST['comment_view_id'])) {
		$user->deletetUserPreference($c_node['user']['preference']['comment_list_view'], $me['user_id']);
		
		if ($_REQUEST['comment_view_id'] == $c_node['user']['pref_options']['comment_list_view']['threaded'] || $_REQUEST['comment_view_id'] == $c_node['user']['pref_options']['comment_list_view']['hybrid']) {
			$user->insertUserPreference($c_node['user']['preference']['comment_list_view'], $me['user_id'], $_REQUEST['comment_view_id']);
		}
	}
	
	$comment_pref = $user->selUserPreference($me['user_id'], $c_node['user']['preference']['comment_list_view'], 1);
	
	if (isset($comment_pref['user_preference_value'])) {
		$_SESSION['user_preferences']['comment_mode'] = $comment_pref['user_preference_value'];
	}
	else {
		$_SESSION['user_preferences']['comment_mode'] = $c_node['user']['pref_options']['comment_list_view']['normal'];
	}
}

?>
