<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
// tom calthrop - node statistics - tom@barnraiser.org


class Statistic {
	// CLASS FUNCTIONS
	// Statistic
	// getStatistics
	// getNodeStatistics
	// setStatistic
	// getStatistic
	
	
	
	// File --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 20th December 2004
	//
	function Statistic($db){
		$this->db = $db;
	} // EO constructor
	
	
	
	// getStatistics ---------------------------------------------------------------
	// returns statistics
	// tom calthrop - 20th December 2004
	//
	function getStatistics() {
		
		$query = "
			SELECT s.statistic_type_id, s.total
			FROM " . $this->db->prefix . "_statistic s
			WHERE "
		;
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->no_user_id)) {
			$query .= "s.user_id is null AND ";
		}
		
		$query .= "1=1 ";
			
		$query .= "order by s.statistic_type_id";
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
	
			$result->Close();
	
			return $temp;
		}
		else {
			$error_info = "function=getStatistics class=Statistic.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getStatistics
	
	
	
	// getAllUserStatistics ---------------------------------------------------------------
	// returns all users statistics
	// tom calthrop - 11th April 2004
	//
	function getAllUserStatistics() {
		$query = "
			SELECT count(user_id) as total_users
			FROM " . $this->db->prefix . "_user
			WHERE status_id=" . $this->user_status['active']
		;
		
		$result = $this->db->Execute($query);
	
		if ($result->fields['total_users']) {
			$temp['total_users'] = $result->fields['total_users'];
			$result->Close();
		}
		else {
			$temp['total_users'] = "0";
		}
	
		//total online now
		$timestamp = $this->db->UserTimeStamp(mktime()-(60*15), "YmdHis"); //last 15 minutes
	
		$query = "
			SELECT count(user_id) as total_online_users
			FROM " . $this->db->prefix . "_user
			WHERE
			active_time > " . $timestamp . " AND 
			status_id=" . $this->user_status['active']
		;
		
		$result = $this->db->Execute($query);
	
		if ($result->fields['total_online_users']) {
			$temp['total_online_users'] = $result->fields['total_online_users'];
			$result->Close();
		}
		else {
			$temp['total_online_users'] = "0";
		}
		
		return $temp;
	
	}//EO getAllUserStatistics
	
	

	// setStatistic --------------------------------------------------------------------
	// set a statistic for the group
	// tom calthrop - 21st Feb 2004
	//
	function setStatistic ($total = null) {
		if (empty($total)) {
		    $total = 0;
		}
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_statistic
			WHERE
			statistic_type_id=" . $this->statistic_type_id . " AND "
		;
		
		if (isset($this->user_id)) {
		    $query .= " user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		
		if (!empty($this->user_id)) {
		    $user_id = $this->user_id;
		}
		else {
		    $user_id = "null";
		}
		
		$rec = array();
		$rec['statistic_type_id'] = $this->statistic_type_id;
		$rec['total'] = $total;
		$rec['user_id'] = $user_id;
		
		$table = $this->db->prefix . "_statistic";
			
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
	}//EO setStatistic
	
	
	
	// getStatistic ---------------------------------------------------------------
	// returns a statistic
	// tom calthrop - 20th December 2004
	//
	function getStatistic() {
		
	$query = "
			SELECT s.total
			FROM " . $this->db->prefix . "_statistic s
			WHERE "
		;
		
		if (isset($this->statistic_type_id)) {
		    $query .= "s.statistic_type_id=" . $this->statistic_type_id . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "s.user_id=" . $this->user_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			if (isset($result->fields['total']) && $result->fields['total'] > 0) {
			    return $result->fields['total'];
			}
			else {
				return "0";
			}
			$result->Close();
	
			
		}
		else {
			$error_info = "function=getStatistic class=Statistic.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getStatistic
}
?>
