<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<?php
	if (isset($library)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($library['library_create_datetime'], 1);?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p class="txt_item_title">
					<?php echo $library['library_title'];?><br />
				</p>
				
				<p>
					<?php echo $library['library_body_display'];?><br />
				</p>
				
				<div class="metadata">
					<p>
						<b><?php echo $lang['txt_author'];?></b> -&#62; 
						<?php echo $lang['txt_profile_nic'];?>: 
						<a href="sn_profile.php?user_id=<?php echo $author['user_id'];?>"><?php echo $author['profile_nic'];?></a>, 
						<?php echo $lang['txt_profile_session_status'];?>: 
						<?php
						if ($author['online_status'] == 1) {
							echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
						}
						else {
								echo $lang['arr_user_online_status'][$author['online_status']];
						}
						?>, 
						<?php echo $lang['txt_hometown'];?>: 
						<?php echo $author['profile_hometown'];?>, 
						<?php echo $lang['txt_joined'];?>: 
						<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
						<br />
					</p>
					
					<p>
						<b><?php echo $lang['hdr_library_item'];?></b> -&#62; 
						
						<?php echo $lang['txt_page_name'];?>:
						<?php echo $library['library_page_name'];?>, 
							
						<?php
						if (isset($newest)) {
						?>
						(<?php echo $lang['txt_version_lastest'];?>&nbsp;<a href="lib_view.php?history_library_id=<?php echo $library['library_id'];?>"><?php echo $lang['href_doc_history'];?></a> )
						<?php
						}
						else {
						?>
						(<?php echo $lang['txt_version_old'];?>&nbsp;<a href="lib_view.php?page=<?php echo $library['library_page_name'];?>"><span class="txt_error"><b><?php echo $lang['href_view_latest'];?></b></span></a> )
						
						<?php }?>, 
									
						<?php
						if (!empty($library['bookmark'])) {
							echo $lang['txt_bookmarks'] . ": ";
							
							if (!empty($library['bookmark']['watch'])) {
								echo $lang['txt_marked'];
							}
							
							if (!empty($library['bookmark']['watch']) && !empty($library['bookmark']['recommend'])) {
								echo "&nbsp;&amp;&nbsp;";
							}
							
							if (!empty($library['bookmark']['recommend'])) {
								echo $lang['txt_tipped'];
							}
							echo ", ";
						}
						?>
						
						<?php echo $lang['txt_published_to'];?>: 
						<?php
						if (isset($library['rsp'])) {
							foreach($library['rsp'] as $key => $i):
								
								echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
								echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
								if ($key+1 < count($library['rsp'])) {
									echo ", ";
								}
								
							endforeach;
						}
						?>
						<br />
					</p>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (isset($me['user_id']) && $library['user_id'] == $me['user_id']) {
					$unlocked = 1;
				}
				
				if (!empty($library['library_allow_comments'])) {
					$unlocked = 1;
				}
				
				$hidden_form = array(
					"library_id" => $library['library_id']
				);
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				include $templatePath . "comment.inc.tpl.php";
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($library_items)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_library'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?
					$display_items = trimArray($library_items);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td valign="top" nowrap="nowrap">
							<?php
							if (isset($profile)) {
							?>
							<a href="lib_view.php?user_id=<?php echo $i['user_id'];?>&amp;library_id=<?php echo $i['library_id'];?>"><?php echo $i['library_create_datetime'];?></a><br />
							<?php
							}
							else {
							?>
							<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><?php echo $this->date->formatDate($i['library_create_datetime']);?></a><br />
							<?php }?>
						</td>
						<td valign="top">
							<?php echo $i['library_title'];?><br />
						</td>
						<td valign="top" width="1%">
							<?php echo $i['library_page_name'];?><br />
						</td>
						<td valign="top" width="1%">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($library_items, $page_list_url . '=1');
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	else {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_library'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_items'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>


<div class="col_side">
	<form action="lib_view.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="library_id" value="<?php if(isset($library['library_id'])) { echo $library['library_id'];}?>" />
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<select name="options" class="options_select">
						<option value="list_node" selected="selected"><?php echo $lang['txt_option_contents'];?></option>
						
						<?php
						$selected = "";
						if (isset($frmdata) && $frmdata['options'] == "firstpage") {
						$selected = "selected=\"selected\"";
						}
						?>
						<option value="firstpage" <?php echo $selected;?>><?php echo $lang['txt_option_fpage'];?></option>
						
						<?php
						if (isset($me['user_id'])) {
						?>
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_my") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_my" <?php echo $selected;?>><?php echo $lang['txt_option_items'];?></option>
							
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_marked") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_marked" <?php echo $selected;?>><?php echo $lang['txt_option_marked'];?></option>
							
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_relation_tips") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_relation_tips" <?php echo $selected;?>><?php echo $lang['txt_option_tipped'];?></option>
							
							<?php
							if (isset($library) && $me['user_id'] > 0) {
							?>
							<option> </option>
							
							<?php
							if (empty($library['bookmark']['watch'])) {
							?>
							<option value="item_mark"><?php echo $lang['txt_option_mark'];?></option>
							<?php }?>
							
							<?php
							if (empty($library['bookmark']['recommend'])) {
							?>
							<option value="item_tip"><?php echo $lang['txt_option_tip'];?></option>
							<?php
							}
							
							if ($this->user_acs->checkPermission($resource_ids['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
							?>
							<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
							<?php }?>
							<?php }?>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['library'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
						?>
							<option> </option>
							<option value="add_wiki_page"><?php echo $lang['txt_option_add'];?></option>
						<?php }?>
					</select>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
				</p>
					
				<?php
				if (isset($library)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
					
					<p>
						<?php
						$tags = "";
						if (isset($item_tags)) {
							foreach ($item_tags as $key => $i):
								$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
								
								if ($i['user_id'] == $me['user_id']) {
									$tags .= "*";
								}
								
								if (count($item_tags) > $key+1) {
									$tags .= ", ";
								}
							endforeach;
							echo $tags;
						}
						?>
					</p>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['library'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
					
					<p>
						<input width="30" name="tags" value="<?php echo $tags;?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
					</p>
					<?php }?>
				<?php }?>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if (isset($sidebar_items)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_history'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				foreach($sidebar_items as $key => $i):
				?>
				<p>
					<a href="lib_view.php?library_id=<?php echo $i['library_id'];?>"><?php echo $this->date->formatDate($i['library_create_datetime'], 1);?></a><br />
					<?php echo $i['library_title'];?><br />
					<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
					<br />
				</p>
				<?php
				endforeach;
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>