<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>


<div class="col_main">
	<?php
	if (isset($subject)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($subject['subject_create_datetime'], 1);?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<p class="txt_item_title">
					<?php echo $subject['subject_title'];?><br />
				</p>
				
				<p>
					<?php echo $subject['display_subject_body'];?><br />
				</p>
			
				<div class="metadata">
					<?php
					if (isset($author)) {
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="sn_profile.php?user_id=<?php echo $author['user_id'];?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_topic'];?></b> -&#62; 
							<a href="frm_view.php?topic_id=<?php echo $subject['topic_id'];?>"><?php echo $topic['topic_title'];?></a><br />
							<?php
							if (isset($topic_roles)) {
							?>
							<p>
								<b><?php echo $lang['hdr_permissions'];?></b>:
									<?php echo $lang['txt_topic_role_add'];?>: 
									<?php
									foreach($topic_roles as $key => $tr):
										echo $lang['arr_acs']['role'][$tr['role_id']];
										if ($key+1 < count($topic_roles)) {
											echo ", ";
										}
									endforeach;
									?>                  
									<br />       
							<?php }?>
						</p>
					
						<p>
							<b><?php echo $lang['hdr_subject'];?></b> -&#62; 
							<?php
							if (isset($subject['subject_sticky'])) {
							?>
							<?php echo $lang['txt_sticky'];?>, 
							<?php }?>
							
							<?php
							if (isset($subject['subject_locked'])) {
							?>
							<?php echo $lang['txt_locked'];?>, 
							<?php }?>
							
							<?php
							if (isset($subject['subject_hidden'])) {
							?>
							<?php echo $lang['txt_hidden'];?>,
							<?php }?>
							<?php
							if (!empty($subject['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($subject['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
								
								if (!empty($subject['bookmark']['watch']) && !empty($subject['bookmark']['recommend'])) {
									echo "&nbsp;&amp;&nbsp;";
								}
								
								if (!empty($subject['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php
							if ($subject['subject_create_datetime'] != $subject['subject_edit_datetime'] && !empty($subject['subject_edit_datetime'])) {
								echo $lang['txt_last_edited'] . ": ";
								echo $this->date->formatDate($subject['subject_edit_datetime'], 1) . ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($subject['rsp'])) {
								foreach($subject['rsp'] as $key => $i):
									
									echo trim($lang['rsp']['rsp_level'][$i['level_id']] . " " . $i['degree_id']);
									echo " (" .$lang['rsp']['status'][$i['status_id']] . ")";
									if ($key+1 < count($subject['rsp'])) {
										echo ", ";
									}
									
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php 
	}
	elseif (!empty($subjects) || !empty($topic)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($display) && $display == "latest") {
				echo $lang['hdr_latest_subjects'];
			}
			else {
				echo $lang['hdr_subjects'];
			}
			?>
			<br />
		</div>
	
		<div class="box_mid">
			<div class="content">
				<?php
				if (!empty($topic)) {
				?>
				<p>
					<?php echo $topic['topic_synopsis'];?><br />
				</p>
				<?php }?>
					
				<?php
				if (!empty($subjects)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					$display_items = trimArray($subjects);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td colspan="2">
							<table width="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td>
										<table width="100%" cellpadding="4" cellspacing="2" border="0">
											<tr>
												
												<td width="28" valign="top" align="center">
													<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>" title="<?php echo $i['subject_title'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
												</td>
												<td valign="top">
													<?php echo $this->date->formatDate($i['subject_create_datetime']);?><br />
													<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>" title="<?php echo $i['subject_title'];?>"><?php echo $i['subject_title'];?></a><br />
													<?php echo dots(140,$i['subject_synopsis']);?><br />
												</td>
												<td valign="top" width="30%">
													<br />
													<?php echo $lang['txt_comment_total'];?>: <?php echo $i['comment_total'];?><br />
													<?php if (!empty($i['last_comment']['comment_create_datetime'])) { echo $lang['txt_last_comment'] . ": " . $this->date->formatDate($i['last_comment']['comment_create_datetime'],1) . "<br />";}?>
													
													<?php
													if (isset($i['movement']['lastview_datetime'])) {
														echo $lang['txt_watching'] . ": " . $lang['txt_lastview'] . " " . $this->date->formatDate($i['movement']['lastview_datetime'], 1) . "<br />";
														echo "(" . $lang['txt_movement'] . " ". $i['movement']['movement'] . ")";
													}
													?>
													
													<?php
													if (isset($i['subject_sticky'])) {
														echo $lang['txt_sticky'] . ", ";
													}
													
													if (isset($i['subject_locked'])) {
														echo $lang['txt_locked'] . ", ";
													}
													
													if (isset($i['subject_hidden'])) {
														echo $lang['txt_hidden'];
													}
													?>
													<br />
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($subjects);
				?>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_latest_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				if (isset($comments)) {
				foreach($comments as $key => $i):
				?>
				
			    <tr>
					<td valign="top">
						<b><a href="frm_view.php?subject_id=<?php echo $i['item_id'];?>"><?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?></a></b><br />
						<?php echo dots(260, $i['comment_body']);?><br />
					</td>
					<td valign="top" width="30%">
						<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a><br />
						<?php echo $lang['txt_joined'];?>: <?php echo $this->date->formatDate($i['profile_create_datetime'], 1);?><br />
						<?php echo $lang['txt_hometown'];?>: <?php echo $i['profile_hometown'];?><br />
					</td>
				</tr>
				<?php
				endforeach;
				} else {
				?>
				<tr>
					<td colspan="2">
						<?php echo $lang['err_no_comments'];?><br />
					</td>
				</tr>
				<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	else {
	?>
	<div class="box">		
		<div class="box_top">
			<?php echo $lang['hdr_subjects'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_subjects'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
			
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($subject)) {
					//comments
					if (isset($me['user_id']) && $subject['user_id'] == $me['user_id']) {
						$unlocked = 1;
					}
						
					if (empty($subject['subject_locked'])) {
						$unlocked = 1;
					}
					
					$hidden_form = array(
						"subject_id" => $subject['subject_id']
					);
					
					
					if (isset($_REQUEST['user_id'])) {
						$hidden_form['user_id'] = $_REQUEST['user_id'];
					}
					
					include $templatePath . "comment.inc.tpl.php";
				
				}
				?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<form action="frm_view.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="subject_id" value="<?php if(isset($subject['subject_id'])) { echo $subject['subject_id'];}?>" />
	<input type="hidden" name="topic_id" value="<?php if(isset($topic['topic_id'])) { echo $topic['topic_id'];}?>" />
	
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<select name="options" class="options_select">
						<option value="list_node" selected="selected"><?php echo $lang['txt_option_group'];?></option>
						
						<?php
						if (isset($me['user_id'])) {
						?>
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_relation") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_relation" <?php echo $selected;?>><?php echo $lang['txt_option_network'];?></option>
							
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_my") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_my" <?php echo $selected;?>><?php echo $lang['txt_option_items'];?></option>
							
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_marked") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_marked" <?php echo $selected;?>><?php echo $lang['txt_option_marked'];?></option>
							
							<?php
							$selected = "";
							if (isset($frmdata) && $frmdata['options'] == "list_relation_tips") {
							$selected = "selected=\"selected\"";
							}
							?>
							<option value="list_relation_tips" <?php echo $selected;?>><?php echo $lang['txt_option_tipped'];?></option>
						<?php }?>
						<option> </option>
						<?php
						if (isset($subject) && $me['user_id'] > 0) {
						?>
						
							<?php
							if (empty($subject['bookmark']['watch'])) {
							?>
							<option value="item_mark"><?php echo $lang['txt_option_mark'];?></option>
							<?php }?>
						
							<?php
							if (empty($subject['bookmark']['recommend'])) {
							?>
							<option value="item_tip"><?php echo $lang['txt_option_tip'];?></option>
							<?php
							}
							if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
							?>
							<option value="subject_edit"><?php echo $lang['txt_option_edit'];?></option>
							<?php }?>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['allow_topic_edit'])) { //resourece_id, Priv_id
						if (isset($topic)) {
						?>
						<option value="topic_edit"><?php echo $lang['txt_option_edit_topic'];?></option>
						<?php }?>
						
						<option value="topic_add"><?php echo $lang['txt_option_add_topic'];?></option>
						<?php }?>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
						?>
						<option value="subject_add"><?php echo $lang['txt_option_add'];?></option>
						<?php }?>
					</select>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
				</p>
				
				<?php
				if (isset($subject)) {
				?>
					<p>
						<b><?php echo $lang['hdr_tag'];?></b><br />
					</p>
					
					<p>
						<?php
						$tags = "";
						if (isset($item_tags)) {
							foreach ($item_tags as $key => $i):
								$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
								
								if ($i['user_id'] == $me['user_id']) {
									$tags .= "*";
								}
								
								if (count($item_tags) > $key+1) {
									$tags .= ", ";
								}
							endforeach;
							echo $tags;
						}
						?>
					</p>
					
					<?php
					if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
					$tags = "";
					if (isset($my_tags)) {
						foreach ($my_tags as $key => $i):
							$tags .= $i['tag_body'];
							if (count($my_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
					}
					?>
					
					<p>
						<input width="30" name="tags" value="<?php echo $tags;?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
					</p>
					<?php }?>
					<?php }?>
					
					<p>
						<b><?php echo $lang['hdr_search'];?></b><br />
					</p>
					
					<p>
						<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
						<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
					</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	
	<?php
	if (isset($sidebar_topics)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_topics'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				foreach($sidebar_topics as $key => $i):
				?>
				<p>
					<?php
					if (isset($topic) && $topic['topic_id'] == $i['topic_id']) {
					?>
					<?php echo $i['topic_title'];?></a><br />
					<?php
					}
					else {
					?>
					<a href="frm_view.php?topic_id=<?php echo $i['topic_id'];?>"><?php echo $i['topic_title'];?></a><br />
					<?php }?>
				</p>
				<?php
				endforeach;
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
