<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Bookmark {
	// CLASS FUNCTIONS
	// Bookmark
	// getBookmarks
	// getBookmark
	// insertBookmark
	// updateBookmark
	// deleteBookmark
	// getBookmarkLastViewDate



	// Bookmark --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 25th Jan 2004
	//
	function Bookmark($db, $rsp_item_type_id, $user_id) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
		$this->user_id = $user_id;
	}



	// getSubjectBookmarks --------------------------------------------------------------------
	// returns multiple rows from the DB
	// the library needs the name and not the id, hence the $return_names var is set to 1 for names
	// tom calthrop - 25th Jan 2004
	//
	function getBookmarks() { //bookmark_name is used for libraryPageName
		$query = "
			SELECT item_id
			FROM " . $this->db->prefix . "_bookmark
			WHERE "
		;
		
		if (!empty($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->user_ids)) {
			$user_ids = "";
			foreach($this->user_ids as $key => $i):
				$user_ids .= $i;
				if (count($this->user_ids) > $key+1) {
				    $user_ids .=",";
				}
			endforeach;
			$query .="user_id in (" . $user_ids . ") and ";
		}
		
		if (isset($this->bookmark_type)) {
		    $query .= "bookmark_type=" . $this->bookmark_type . " and ";
		}

		if (isset($this->rsp_item_type_ids)) {
			$query .= "rsp_item_type_id in (" . $this->rsp_item_type_ids . ") AND ";
		}
		elseif (isset($this->rsp_item_type_id)) {
			$query .= "rsp_item_type_id=" . $this->rsp_item_type_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields['item_id']);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getBookmarks class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getBookmarks



	// getBookmark --------------------------------------------------------------------
	// gets the bookmark (returns true if found)
	// tom calthrop - 11th December 2004
	//
	function getBookmark() {

		$query = "
			SELECT user_id
			FROM " . $this->db->prefix . "_bookmark
			WHERE
			user_id=" . $this->user_id . " and
			rsp_item_type_id=" . $this->rsp_item_type_id . " and
			bookmark_type=" . $this->bookmark_type . " and
			item_id=" . $this->item_id . " and "
		;

		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['user_id'])) {
			return true;
		}
		else {
			return false;
		}
	} //EO getBookmark



	// insertBookmark --------------------------------------------------------------------
	// inserts the bookmark
	// tom calthrop - 11th December 2004
	//
	function insertBookmark() {
		
		$rec = array();
		$rec['item_id'] = $this->item_id;
		$rec['rsp_item_type_id'] = $this->rsp_item_type_id;
		$rec['bookmark_type'] = $this->bookmark_type;
		$rec['user_id'] = $this->user_id;
		$rec['bookmark_lastview_datetime'] = time();
		
		$table = $this->db->prefix . "_bookmark";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "function=insertBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	} //EO insertBookmark



	// updateBookmark --------------------------------------------------------------------
	// updates the bookmark_lastview_datetime
	// tom calthrop - 11th December 2004
	//
	function updateBookmark() {
		$query = "
			SELECT * FROM " . $this->db->prefix . "_bookmark 
			WHERE 
			rsp_item_type_id=" . $this->rsp_item_type_id . " and
			bookmark_type=" . $this->bookmark_type . " and
			user_id=" . $this->user_id . " and
			item_id=" . $this->item_id
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['bookmark_lastview_datetime'] = time();
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=updateBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
		}
	} //EO updateBookmark



	// deleteBookmark --------------------------------------------------------------------
	// deletes a  bookmark
	// tom calthrop - 11th December 2004
	//
	function deleteBookmark($del_arr = null) {
		
		if (isset($this->rsp_item_type_ids)) {
			$rsp_item_type_ids = $this->rsp_item_type_ids;
		}
		else {
			$rsp_item_type_ids = $this->rsp_item_type_id;
		}
		
		if (empty($del_arr)) {
		    $del_arr = array($this->item_id);
		}

		$rownums = count($del_arr);

		for ($i=0; $i < $rownums; $i++) {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_bookmark
				WHERE
				rsp_item_type_id in (" . $rsp_item_type_ids . ") AND 
				bookmark_type=" . $this->bookmark_type . " and
				user_id=" . $this->user_id . " and
				item_id=" . $del_arr[$i]
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$error_info = "function=deleteBookmark class=Bookmark.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['igloo_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteBookmark


	// getBookmarkLastViewDate --------------------------------------------------------------------
	// gets the bookmarks last view date
	// tom calthrop - 11th December 2004
	//
	function getBookmarkLastViewDate($item_id = null) {

		if (!isset($item_id) && isset($this->item_id)) {
		    $item_id = $this->item_id;
		}

		$query = "
			SELECT bookmark_lastview_datetime
			FROM " . $this->db->prefix . "_bookmark
			WHERE
			user_id=" . $this->user_id . " and
			bookmark_type=" . $this->bookmark_type . " and
			rsp_item_type_id=" . $this->rsp_item_type_id . " and
			item_id=" . $item_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields['bookmark_lastview_datetime'])) {
			return $result->fields['bookmark_lastview_datetime'];
		}
		else {
			return false;
		}
	} //EO getBookmarkLastViewDate

}
?>
