# Copyright 2009 Ben Escoto
#
# This file is part of Explicans.

# Explicans is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Explicans is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Explicans.  If not, see <http://www.gnu.org/licenses/>.

"""PyQt4 port of the layouts/basiclayout example from Qt v4.x"""

import sys, types
from PyQt4 import QtCore, QtGui
import stylesheets, widgets

sig_trigger = QtCore.SIGNAL("triggered()")

class MainWindow(QtGui.QMainWindow):
    def __init__(self):
        """Create the entire display from initial tuple string"""
        QtGui.QMainWindow.__init__(self)
        #self.setStyleSheet(stylesheets.background)
        self.createMenus()
        self.createScroll()

    def createMenus(self):
        """Initialize the Menus"""
        #self.menuBar().setStyleSheet('background-color: %s;' %
        #                            StyleSheets.menu_color)
        self.fileMenu = self.menuBar().addMenu(self.tr("&File"))
        self.exitAct = QtGui.QAction(self.tr("E&xit"), self)
        self.connect(self.exitAct, sig_trigger, QtCore.SLOT("close()"))
        self.fileMenu.addAction(self.exitAct)

    def createScroll(self):
        """Create a scrollable viewing area"""
        self.scrollarea = QtGui.QScrollArea()
        self.scrollarea.setStyleSheet(stylesheets.background)
        self.scrollarea.setMinimumSize(300, 200)
        self.setCentralWidget(self.scrollarea)

class ListDemo(QtGui.QWidget):
    def __init__(self, orientation):
        QtGui.QWidget.__init__(self)
        self.layout = QtGui.QGridLayout()
        self.layout.setSpacing(0)
        self.orientation = orientation

        wd = self.get_widget_dict()
        for i in range(3):
            for j in range(3):
                self.layout.addWidget(wd[(i,j)], i, j)

        self.setLayout(self.layout)        

    def get_widget_dict(self):
        """Return dictionary mapping (row, col) coords to widgets"""
        wd = {}
        wd[(0,0)] = QtGui.QLineEdit()
        s = stylesheets.get_style('name', self.orientation,
                                  set(('top', 'left')))
        wd[(0,0)].setStyleSheet(s)

        wd[(0,1)] = QtGui.QLineEdit()
        s = stylesheets.get_style('func', self.orientation,
                                  set(('top',)))
        wd[(0,1)].setStyleSheet(s)

        wd[(0,2)] = QtGui.QLabel()
        s = stylesheets.get_style('value', self.orientation,
                                  set(('top', 'right')))
        wd[(0,2)].setMinimumWidth(40)
        wd[(0,2)].setStyleSheet(s)

        wd[(1,0)] = QtGui.QLineEdit()
        s = stylesheets.get_style('name', self.orientation,
                                  set(('left',)))
        wd[(1,0)].setStyleSheet(s)

        wd[(1,1)] = QtGui.QLineEdit()
        s = stylesheets.get_style('func', self.orientation,
                                  set(()))
        print s
        wd[(1,1)].setStyleSheet(s)
        
        wd[(1,2)] = QtGui.QLabel()
        s = stylesheets.get_style('value', self.orientation,
                                  set(('right',)))
        wd[(1,2)].setMinimumWidth(40)
        wd[(1,2)].setStyleSheet(s)

        wd[(2,0)] = QtGui.QLineEdit()
        s = stylesheets.get_style('name', self.orientation,
                                  set(('left', 'bottom')))
        wd[(2,0)].setStyleSheet(s)

        wd[(2,1)] = QtGui.QLineEdit()
        s = stylesheets.get_style('func', self.orientation,
                                  set(('bottom',)))
        wd[(2,1)].setStyleSheet(s)

        wd[(2,2)] = QtGui.QLabel()
        s = stylesheets.get_style('value', self.orientation,
                                  set(('right', 'bottom')))
        wd[(2,2)].setMinimumWidth(40)
        wd[(2,2)].setStyleSheet(s)

        return wd


def Main(qt_args, selection):
    """Display the selected widget"""
    app = QtGui.QApplication(qt_args)
    mainWin = MainWindow()
    orientation = 'tall'
    widget = get_widget(selection)
    mainWin.scrollarea.setWidget(widget)
    mainWin.show()
    sys.exit(app.exec_())

def get_widget(selection):
    """Return the widget indicated by selection string"""
    orientation = 'tall'
    if selection == 'listdemo':
        return ListDemo(orientation)
    elif selection == 'listsection':
        return widgets.ListSection(orientation, 3, True, True)
    elif selection == 'table2d':
        table2d = widgets.Table2D(3,3)
        table2d.connect(table2d, QtCore.SIGNAL('editingFinished'),
                        table2d_signal_handler)
        return table2d
    else: assert False, ("Unknown widget argument", selection)

def table2d_signal_handler(comptype, axis, loc, text):
    """This should be called when values are changed somewhere in the table"""
    print "Comptype: %s, Axis: %s, Index: %s" % (comptype, axis, loc)
    print "New text:", text


if __name__ == "__main__":
    if len(sys.argv) < 2:
        print """
This program displays an example widget.

Usage: widgettest [arguments for QT]* [selection]

Where selection is one of:

    listdemo - show the simple widget contained in this test
    listsection - show ListSection widget
    table2d - show a two dimensional table
"""
        sys.exit(1)
    Main(sys.argv[:-1], sys.argv[-1])
