#Installation Process

## Dependencies of the speckleonline program

* **Qt5** developer files.
* **opencv-3.4.6-vc14_vc15** or any in the family 3.X. (this code currently has some incompatibilities with 2.X family.)

## Building the project in Windows

For compile the **speckleonline.exe** program in windows we need:

1. Download **opencv-3.4.6-vc14_vc15** source code for Windows from http://opencv.org/downloads.html and uncompress (by example) in `c:\\` drive, so that the final installation directory will be `c:/user/username/downloads/opencv`.
2. Download **qtcreator** (qt-opensource-windows-x86-mingw530-5.8.0.exe) from https://www.qt.io/download-open-source/ and install in `C:\`.
3. Compile **opencv-3.4.6-vc14_vc15** source code with  **mingw** tool chain of **qt-creator** program, these are located in `C:\Qt_2019\Tools\mingw730_64\bin`, the **opencv-3.4.6-vc14_vc15** code need the **CMake** program to be prepared, thus you need download it. The compiled source code should be installed in `C:\OpenCV3.x`.
4. Open **qtcreator** select the `speckleonline.pro` file and **Build all**. With this process you got the **speckleonline.exe** program file. Or:
    makewin.bat
### Compiling the source code of OpenCV
(info source:https://zahidhasan.wordpress.com/2014/08/19/qt-5-3-1-64-bit-mingw-windows/)

1. Open path editor and set the following two folder into system variable. `C:\Qt_2019\Tools\mingw730_64\bin` and `C:\Program Files\CMake\bin`
2. Open cmake-gui, set source path to `c:/user/username/downloads/opencv` and binary path to `C:\OpenCV3.x`
3. Hit **configure** button. A pop up window will open and the from drop-down menu select **MinGW Makefiles** and press next.   
4. Modify to WITH_OPENCL=ON, WITH_OPENCL_D3D11_NV=OFF, WITH_DIRECTX=ON
5. And finally press **generate** button.
6. Now open command prompt go to `OpenCV3.x`. Type: mingw32–make 
7. Now type: mingw32–make install

## Directory hierarchy

For the **speckleonline.exe** program works correctly, only are necessary the **speckleonline.exe** program and the **shared** directory, so that these fulfill the next directory hierarchy:

    ./win/  speckleonline.nsi

    ./bin/  speckleonline.exe
            libgcc_s_dw2-1.dll
            libstdc++-6.dll
            libwinpthread-1.dll
            Qt5Widgets.dll
            Qt5Core.dll
            Qt5Gui.dll
            libopencv_core346.dll
            libopencv_video346.dll
            libopencv_highgui346.dll
            libopencv_imgproc346.dll

            
    ./bin/platforms/qwindows.dll
    
    ./share/doc/speckleonline/    SpeckleTool-UserGuide.pdf
    
    ./share/speckleonline/icons/  camera.ico
                                document-open.png
                                document-save-as.png
                                help-about.png
                                camera.png
                                document-properties.png
                                document-save.png
                                help-contents.png
    ./share/applications/       speckleonline.desktop


The `*.dll` files in `bin` can be found in `C:\Qt_2019\5.12.2\mingw73_64\bin` or `C:\OpenCV3.x\install\x64\mingw\bin` or `C:\Qt_2019\5.12.2\mingw73_64\plugins\`


