<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Filter_Client
{


  // Returns true if Client mode is enabled. Else it returns false.
  public static function enabled ()
  {
    $database_config_general = Database_Config_General::getInstance ();
    $enabled = $database_config_general->getClientMode ();
    if ($enabled) return true;
    return false;
  }


  public static function createNoteEncode ($bible, $book, $chapter, $verse, $summary, $contents, $raw)
  {
    $data = array ();
    $data [] = $bible;
    $data [] = $book;
    $data [] = $chapter;
    $data [] = $verse;
    $data [] = $summary;
    $data [] = $raw;
    $data [] = $contents;
    $data = implode ("\n", $data);
    return $data;
  }
  
  
  public static function createNoteDecode ($data)
  {
    $data = explode ("\n", $data);
    $result = array ();
    $result ["bible"] = array_shift ($data);
    $result ["book"] = array_shift ($data);
    $result ["chapter"] = array_shift ($data);
    $result ["verse"] = array_shift ($data);
    $result ["summary"] = array_shift ($data);
    $result ["raw"] = array_shift ($data);
    $result ["contents"] = implode ("\n", $data);
    return $result;
  }
  

}

?>
