<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


Bootstrap::getInstance ();


function page_access_level ($level)
{
  $session_logic = Session_Logic::getInstance ();
  if ($level > $session_logic->currentLevel ()) {
    $header = new Assets_Header ("Privileges");
    $header->setLogin ();
    $header->run ();
    $view = new Assets_View (__FILE__);
    $view->render ("privileges.php");
    Assets_Page::footer ();
    die ();
  }
}


class Bootstrap
{
  private static $instance;
  public $bibledit_root_folder;


  private function __construct()
  {

    // Default encoding.
    mb_internal_encoding ("UTF-8");
    
    // On shared hosting the temporal location may give read or write failures.
    // Set private temporal location for PHP.
    // Set private temporal location for SQLite.
    // http://stackoverflow.com/questions/10394517/setting-sqlite-temp-store-directory
    $tmpdir = realpath (__DIR__ . "/../tmp");
    putenv ("TMPDIR=$tmpdir");

    // Check whether to run the website setup script.
    if (file_exists ("../setup")) {
      $setupfolder = realpath ("../setup");
      $myfolder = realpath (".");
      if ($setupfolder != $myfolder) {
        header('Location: ../setup');
        die;
      }
    }

    // Set the include path, where to look for included files.
    $this->bibledit_root_folder = dirname (dirname(__FILE__));
    // Include the Zend path for unit tests first, and if the Zend path is found on an
    // installed system, take that instead.
    $zendpath = realpath ($this->bibledit_root_folder . "/../../Zend");
    @include $this->bibledit_root_folder . "/config/zend.php";
    $include_path = get_include_path () . ":" . $this->bibledit_root_folder . ":" . dirname ($zendpath);
    set_include_path ($include_path);
    ini_set('include_path', $include_path);

    // Autoloader.
    // Automatically include the file that contains the $class_name.
    // E.g. class Database_Bibles would require file database/bibles.php.
    // Thus the name of the class determines which file gets required.
    // The above implies that all classes translate to files and folders in lower case.
    // An exception is made for the Zend_* classes.
    function __autoload ($class_name)
    {
      if (substr ($class_name, 0, 4) != "Zend") {
        $class_name = strtolower ($class_name);
      }
      $path = str_replace ("_", "/", $class_name);
      require_once $path.".php";
    }
    // Register the function.
    spl_autoload_register ('__autoload');


    // Disable magic quotes.
    if ( (function_exists("get_magic_quotes_gpc")) && get_magic_quotes_gpc() ) {
      foreach($_GET    as $k => $v) $_GET   [$k] = stripslashes($v);
      foreach($_POST   as $k => $v) $_POST  [$k] = stripslashes($v);
      foreach($_COOKIE as $k => $v) $_COOKIE[$k] = stripslashes($v);
    }

    // General configuration database.
    $database_config_general = Database_Config_General::getInstance();

    // The site's timezone.
    $timezone = $database_config_general->getTimezone ();
    date_default_timezone_set ($timezone);

    // The localization.
    $language = $database_config_general->getSiteLanguage ();
    if ($language != "") {
      putenv("LANGUAGE=$language");
      setlocale(LC_MESSAGES, "en_US.utf8"); // I am puzzled as to why this is needed to make gettext work.
      $textdomain = dirname (dirname (__FILE__)) . "/locale";
      bindtextdomain("bibledit", $textdomain);
      textdomain("bibledit");
    }
    // Another way of localization is this:
    // * Setup the Zend_Translate adapter for gettext and the path to the .mo file.
    // * Replace the gettext calls in the non-viewer .php scripts with $this->translate...
    // * http://stackoverflow.com/questions/9127197/zend-gettext-and-mo-po-files
    // * Ensure that the scanner for finding translatable strings also finds the new way of putting the strings.

  }


  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Bootstrap();
    }
    return self::$instance;
  }
}


?>
