<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);
ini_set('display_errors', '1');


require_once ("../database/sqlite.php");
require_once ("../filter/folders.php");
require_once ("../database/usfmresources.php");


// Import USFM Resources from the database to the filesystem, if they don't exist on the filesystem yet.
$database_usfmresources = Database_UsfmResources::getInstance ();
$resources = $database_usfmresources->getResources ();
if (count ($resources) == 0) {
  $db = Database_SQLite::connect ("usfmresources");
  $query = "SELECT * FROM usfmresources;";
  $result = $db->exec ($query);
  if ($result == false) die;
  foreach ($result as $row) {
    $name = $row ['name'];
    $book = $row ['book'];
    $chapter = $row ['chapter'];
    $usfm = $row ['usfm'];
    $database_usfmresources->storeChapter ($name, $book, $chapter, $usfm);
  }
}


?>
