<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);


require_once ("../bootstrap/bootstrap.php");


$messages = array ();


// The entry to go into cron.
$folder = realpath ("../timer");
$signature = "* * * * * cd $folder; php index.php; cd";


// Get current crontab contents.
$result = array ();
exec ("crontab -l 2>&1", $result, $exitcode);
// Errors may be caused by an empty crontab.
if ($exitcode != 0) {
  $result = array ();
}


// If the entry is not there yet, add it.
$included = false;
foreach ($result as $line) {
  if ($line == $signature) $included = true;
}
if (!$included) {
  $result [] = $signature;
  $content = implode ("\n", $result) . "\n";
  $filename = tempnam (sys_get_temp_dir (), '');
  file_put_contents ($filename, $content);
  $result = array ();
  exec ("crontab $filename 2>&1", $result, $exitcode);
  if ($exitcode != 0) {
    $messages [] = "Crontab ran with an exitcode of $exitcode, while 0 would be expected. Therefore the scheduled task for Bibledit-Web may not have been set properly.";
    foreach ($result as $line) {
      $messages [] = "Error: " . $line;
    }
  }
  unlink ($filename);
}


if (count ($messages) == 0) {
  header ("Location: step.php?referer=crontab");
  die;
}


$webuser = posix_getpwuid (posix_geteuid ());
$webuser = $webuser ['name'];


?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Bibledit-Web Installation</title>
<link rel="stylesheet" href="stylesheet.css" type="text/css" />
</head>
<body>
<h1><img src="../assets/bibledit.png"> <a href="http://bibledit.org/">Bibledit-Web</a></h1>
<p>Bibledit-Web tried to configure the timer for running scheduled tasks through program <code>crontab</code>, but failed to do so.</p>
<p>More information is below.</p>
<ul>
<?php
foreach ($messages as $message) {
  echo "<li>$message</li>\n";
}
?>
</ul>
<p>May you ensure that the following scheduled task is set properly in the <code>cron</code> scheduler for user <code><?php echo $webuser; ?></code>:</p>
<p><code><?php echo $signature; ?></code></p>
<p>If the <code>cron</code> scheduler does not work for user <code><?php echo $webuser; ?></code>, it is also an option to schedule the tasks as user <code>root</code>. Run <code>crontab -e</code> as user <code>root</code>, and enter the following line given above.</p>
<p>Your hosting provider will be able to advise also.</p>
<p><a href="crontab.php" class="button button-large">Retry</a> <a href="step.php?referer=crontab" class="button button-large">Carry on</a></p>
</body>
</html>
