<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Tasks
{
  /**
  * Singleton logic.
  */
  private static $instance;
  private $db;
  private function __construct () {
    $this->db = Database_SQLite::connect ("tasks");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Tasks();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS tasks (
  process varchar (256),
  priority int,
  pid int,
  logfile varchar(1024),
  expire int
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  public function optimize () {
    Database_SQLite::exec ($this->db, "REINDEX tasks;");
    Database_SQLite::exec ($this->db, "VACUUM tasks;");
  }
  
  
  // Queue $process and set its $priority.
  // If $process already exists in the queue, then its existing priority is bumped up.
  public function queue ($process, $priority)
  {
    $queued = $this->queued ($process);
    $process = Database_SQLiteInjection::no ($process);
    $priority = Database_SQLiteInjection::no ($priority);
    if ($queued) {
      $query = "UPDATE tasks SET priority = priority + 1 WHERE process = '$process';";
    } else {
      $query = "INSERT INTO tasks (process, priority) VALUES ('$process', $priority);";
    }
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  // Get details of the next task to run.
  // If there's none, it returns false.
  // If there's one, it returns an array with information to run.
  public function next ()
  {
    $query = "SELECT ROWID, process, pid FROM tasks ORDER BY pid ASC, priority DESC, ROWID ASC LIMIT 1;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $pid = $row ['pid'];
      if (!$pid) return $row;
    }
    return false;
  }
  
  
  public function run ($id, $pid, $logfile)
  {
    $id = Database_SQLiteInjection::no ($id);
    $pid = Database_SQLiteInjection::no ($pid);
    $logfile = Database_SQLiteInjection::no ($logfile);
    $expire = strtotime ("+3 days");
    $query = "UPDATE tasks SET pid = $pid, logfile = '$logfile', expire = $expire WHERE ROWID = $id;";
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  // Returns an array of active or completed tasks.
  public function actives ()
  {
    $actives = array ();
    $query = "SELECT ROWID, process, pid, logfile FROM tasks WHERE pid LIMIT 30;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $actives [] = $row;
    }
    return $actives;
  }


  public function erase ($rowid)
  {
    $rowid = Database_SQLiteInjection::no ($rowid);
    $query = "DELETE FROM tasks WHERE ROWID = $rowid;";
    Database_SQLite::exec ($this->db, $query);
  }
  
  
  // Returns true if $process runs.
  public function runs ($process)
  {
    $process = Database_SQLiteInjection::no ($process);
    $query = "SELECT ROWID FROM tasks WHERE pid AND process LIKE '%$process%';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) return true;
    return false;
  }
  

  // Returns true if $process has been queued or runs.
  public function queued ($process)
  {
    $process = Database_SQLiteInjection::no ($process);
    $query = "SELECT ROWID FROM tasks WHERE process LIKE '%$process%';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) return true;
    return false;
  }
  

  // Get an array of expired processes.
  public function expired ()
  {
    $pids = array ();
    $time = time ();
    $query = "SELECT pid FROM tasks WHERE $time >= expire;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $pid = $row ['pid'];
      $pids [] = $pid;
    }
    return $pids;
  }
  
  
}



?>
