<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Logs
{
  /**
  * Singleton logic.
  */
  private static $instance;
  private $db;
  private function __construct () {
    $file = dirname (__DIR__) . "/databases/logs.sqlite";
    $this->db = new PDO ("sqlite:$file");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Logs();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS logs (
  timestamp int,
  level int,
  event text
);
EOD;
    $this->db->exec ($sql);
  }


  public function optimize () {
    $this->db->exec ("REINDEX logs;");
    $this->db->exec ("VACUUM logs;");
  }


  public function trim ()
  {
    $timestamp = strtotime ("-5 days");
    $query = "DELETE FROM logs WHERE timestamp < $timestamp;";
    $this->db->exec ($query);
  }


  // Logs entry.
  public function log ($description, $level = 5)
  {
    $description = Database_SQLiteInjection::no ($description);
    $level = Database_SQLiteInjection::no ($level);
    $time = time();
    $query = "INSERT INTO logs (timestamp, level, event) VALUES ($time, $level, '$description');";
    // The following query function never should go through class Database_SQLite to avoid an infinite loop in case of errors.
    $this->db->exec ($query);
  }


  // Get the logbook entries.
  // $start and $end are the timestamps that limit the returned result.
  public function get ($start, $end) {
    $session_logic = Session_Logic::getInstance ();
    $level = $session_logic->currentLevel ();
    $today = strtotime ("today");
    $start = (int) $start;
    $end = (int) $end;
    $query = "SELECT rowid, timestamp, event FROM logs WHERE timestamp >= $start AND timestamp < $end AND level <= $level ORDER BY ROWID;";
    // The following query function not should go through class Database_SQLite to avoid an infinite loop in case of errors.
    $result = $this->db->query ($query);
    return $result;
  }


  // Gets the logbook entry with id higher than $id.
  public function getNext ($id) {
    $id = (int) $id;
    $session_logic = Session_Logic::getInstance ();
    $level = $session_logic->currentLevel ();
    $query = "SELECT rowid, timestamp, event FROM logs WHERE ROWID > $id AND level <= $level ORDER BY ROWID ASC LIMIT 1;";
    // The following query function not should go through class Database_SQLite to avoid an infinite loop in case of errors.
    $result = $this->db->query ($query);
    return $result;
  }


}



?>
