<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

class Consistency_Logic
{

  public $passages;
  public $translations;


  private $siteUrl;
  private $response;


  public function response ()
  {
    $database_config_general = Database_Config_General::getInstance ();
    $database_config_user = Database_Config_User::getInstance ();
    $resources = array ();
    $resources [] = $database_config_user->getBible ();
    $resources = array_merge ($resources, $database_config_user->getConsistencyResources ());
    $this->siteUrl = $database_config_general->getSiteURL ();
    $this->translations = trim ($this->translations);
    $translations = Filter_String::string2array ($this->translations);
    $this->response = array ();
    $passages = explode ("\n", $this->passages);
    $previousPassage = array (1, 1, 1);
    foreach ($passages as $line) {
      $line = trim ($line);
      if ($line == "") continue;
      $range_sequence = Filter_Books::handleSequencesRanges ($line);
      foreach ($range_sequence as $line) {
        $passage = Filter_Books::interpretPassage ($previousPassage, $line);
        if ($passage[0] != 0) {
          $book = $passage [0];
          $chapter = $passage [1];
          $verse = $passage [2];
          $text = Filter_Books::passageDisplay ($book, $chapter, $verse);
          $line = '<a class="navigate" href="' . "$book.$chapter.$verse" . '">' . $text . "</a>";
          $line .= " ";
          foreach ($resources as $resource) {
            $text = $this->verseText ($resource, $book, $chapter, $verse);
            if ($this->translations != "") {
              $text = Filter_Markup::words ($translations, $text);
            }
            if (count ($resources) > 1) {
              $line .= "<br>";
            }
            $line .= $text;
          }
          $this->response [] = $line;
          $previousPassage = $passage;
        } else {
          $this->response [] = '<span class="error">' . gettext ("Unknown passage") . " " . $line . '</span>';
        }
      }
    }
    $response = "";
    foreach ($this->response as $line) {
      $response .= "<div>$line</div>\n";
    }
    return $response;
  }


  private function verseText ($resource, $book, $chapter, $verse)
  {
    $text = Resource_Logic::getText ($resource, $book, $chapter, $verse);
    return $text;
  }


}


?>
