<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

require_once ("../bootstrap/bootstrap.php");
page_access_level ((Filter_Roles::MANAGER_LEVEL));

Assets_Page::header (gettext ("Bible"));
$view = new Assets_View (__FILE__);
$database_bibles = Database_Bibles::getInstance();
$database_books = Database_Books::getInstance();

// The Bible.
$bible = $_GET['bible'];
$view->view->bible = Filter_Html::sanitize ($bible);

// Versification.
@$versification = $_GET['versification'];
if (isset ($versification)) {
  if ($versification == "") {
    $dialog_versifications = new Dialog_List (array ("bible"), gettext ("Would you like to change the versification system?"), gettext ("A versification system determines how many chapters are in each book, and how many verses are in each chapter. Please make your choice below."), "");
    $database_versifications = Database_Versifications::getInstance ();
    $versification_names = $database_versifications->getSystems ();
    foreach ($versification_names as $versification_name) {
      $dialog_versifications->add_row ($versification_name, "&versification=$versification_name");
    }
    $dialog_versifications->run();
    die;
  } else {
    $database_bibles->setVersification ($bible, $versification);
  }
}
$versification = $database_bibles->getVersification ($bible);
$view->view->versification = $versification;

// Book creation.
@$createbook = $_GET['createbook'];
if (isset ($createbook)) {
  if ($createbook == "") {
    $dialog_books = new Dialog_Books (array ("bible"), gettext ("Create book"), "", "", "createbook", NULL, $database_bibles->getBooks ($bible));
    die;
  } else {
    $feedback = array ();
    Book_Create::create ($bible, $createbook, NULL, $feedback);
  }
}

// Book deletion.
@$deletebook = $_GET['deletebook'];
if ($deletebook != "") {
  @$confirm = $_GET['confirm'];
  if ($confirm != "") {
    $database_bibles->deleteBook ($bible, $deletebook);
  } else {
    $dialog_yes = new Dialog_Yes (array ("bible"), gettext ("Would you like to delete this book?"), "deletebook");
    die;
  }
}


// Available books.
$book_names = array ();
$book_ids = $database_bibles->getBooks ($bible);
foreach ($book_ids as $book) {
  $book_name = $database_books->getEnglishFromId ($book);
  $book_name = gettext ($book_name);
  $book_names [] = $book_name;
}
$view->view->book_ids = $book_ids;
$view->view->book_names = $book_names;
$view->view->book_count = count ($book_ids);

$view->render ("settings.php");

Assets_Page::footer ();
?>
