<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";
include "inc/header.inc.php";

if (!isset($_SESSION['s_user_id'])) {
	if (isset($_REQUEST['item_id'])) {
		$url = "account.php?item_id=" . $_REQUEST['item_id'];
	}
	else {
		$url = "account.php";
	}
	return header("Location: " . $url);
	exit;
}

if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['newsletter'], $c_acs['arr_acs']['privilege']['allow_edit'])) {
	header("Location: index.php?" . SID);
	exit;
}

require_once($c_node['dir']['class_path'] . 'Newsletter.class.php');
$nl = new Newsletter($db, null);


// SETUP NEWSLETTER -----------------------------------------------------
if (!empty($_REQUEST['message_id'])) {
	$output_newsletter = $nl->selNewsletter($_REQUEST['message_id']);
	//wikify body
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_newsletter['message_body'] = $wiki->transform($output_newsletter['message_body'], 'Xhtml');
	
	$display = "view";
}
elseif (isset($_POST['send_newsletter'])) {
	
	$nl->insertNewsletter($frmdata);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		//send newsletter
		if($c_node['cron']['bulk_email'] != 1) {
			//we send email directly 
			unset($_SESSION["newsletter_id"]);
			$_SESSION["newsletter_id"] = $nl->message_id;
			header("Location: newsletter_send.php");
			exit;
		}
	}
}
elseif (isset($_REQUEST['complete'])) {
	if ($_REQUEST['complete'] < 1) {
		$_REQUEST['complete'] = 0;
	}
	
	$lang['arr_error'][20] = str_replace("NUMBER", $_REQUEST['complete'], $lang['arr_error'][20]);
	$GLOBALS['beacon_error_log'][] = array(20, null);
}
else {
	$display = "edit";
	
}

//move to template
if (!empty($output_newsletter)) {
	$body->set('newsletter', $output_newsletter);
}

include "inc/footer.inc.php";

?>
