#
# Table structure for table `beacon_category`
#
CREATE TABLE `beacon_category` (
  `category_id` int(11) NOT NULL auto_increment,
  `category_name` varchar(50) default NULL,
  `language_id` int(11) default NULL,
  `parent_id` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`category_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_comment`
#
CREATE TABLE `beacon_comment` (
  `comment_id` int(11) NOT NULL auto_increment,
  `comment_parent_id` int(11) default NULL,
  `item_id` int(11) default NULL,
  `comment_body` text,
  `comment_create_datetime` datetime default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`comment_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_file`
#
CREATE TABLE `beacon_file` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_suffix` varchar(4) default NULL,
  `file_name` varchar(50) default NULL,
  `file_size` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`file_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_item`
#
CREATE TABLE `beacon_item` (
  `item_id` int(11) NOT NULL auto_increment,
  `item_title` varchar(255) default NULL,
  `item_synopsis` varchar(255) default NULL,
  `item_body` text,
  `item_note` text,
  `item_create_datetime` datetime default NULL,
  `wiki_id` int(11) default NULL,
  `language_id` int(11) default NULL,
  `category_id` int(11) default NULL,
  `beacon_default_page` int(1) default NULL,
  `user_id` int(11) default NULL,
  `allow_comment` int(1) default NULL,
  `status_id` int(1) default NULL,
  PRIMARY KEY  (`item_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_menu`
#
CREATE TABLE `beacon_menu` (
  `menu_id` int(11) NOT NULL auto_increment,
  `menu_location_id` int(11) default NULL,
  `menu_title` varchar(50) default NULL,
  `menu_link` varchar(100) default NULL,
  `menu_link_type_id` int(11) default NULL,
  `language_id` int(11) default NULL,
  `menu_order` int(11) default NULL,
  `user_id` int(11) default NULL,
  PRIMARY KEY  (`menu_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_newsletter`
#
CREATE TABLE `beacon_newsletter` (
  `message_id` int(11) NOT NULL auto_increment,
  `from_user_id` int(11) default NULL,
  `message_subject` varchar(50) default NULL,
  `message_body` text,
  `message_create_datetime` datetime default NULL,
  `language_id` int(11) default NULL,
  `start_id` int(11) default NULL,
  `message_status` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`message_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_permission`
#
CREATE TABLE `beacon_permission` (
  `user_id` int(11) default NULL,
  `permission_id` int(11) default NULL
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_user`
#
CREATE TABLE `beacon_user` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_name` varchar(50) default NULL,
  `user_email` varchar(100) default NULL,
  `user_password` varchar(32) default NULL,
  `show_email` int(1) default NULL,
  `allow_correspondence` int(1) default NULL,
  `user_create_datetime` datetime default NULL,
  `user_last_login_datetime` datetime default NULL,
  `language_id` int(3) default NULL,
  `status_id` int(1) default NULL,
  PRIMARY KEY  (`user_id`)
) TYPE=InnoDB CHARACTER SET utf8;

#
# Table structure for table `beacon_wiki`
#
CREATE TABLE `beacon_wiki` (
  `wiki_id` int(11) NOT NULL auto_increment,
  `wiki_page` varchar(50) default NULL,
  `current_item_id` int(11) default NULL,
  PRIMARY KEY  (`wiki_id`)
) TYPE=InnoDB CHARACTER SET utf8;


