<?php

// -----------------------------------------------------------------------
// This file is part of beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

// BeaconObjList
// Lists Beacon items as contents, latest or history...
// contents - full list of unique wiki_page items
// history - full list of one item
// latest - last X page edits


class Text_Wiki_Render_Xhtml_Beaconlist extends Text_Wiki_Render {

    var $conf = array(
        'type' => 'latest',
        'limit' => null,
        'css'  => null
    );
    
    
    function token($options) {
		
		global $item, $output_item;
		
		unset($item->limit);
		if (isset($options['attr']['limit'])) {
			$item->limit = $options['attr']['limit'];
			// unset so it won't show up as an attribute
			unset($options['attr']['limit']);
		}
		
		
		//LISTS
		//History, a list of the history of this article – shows previous and newer versions of this article.
		//Similar: lists other articles under this category
		//Contents: lists newest version of every article 
		//Latest: last edited articles
		if (isset($options['attr']['type'])) {
			$list_type = $options['attr']['type'];
			// unset so it won't show up as an attribute
			unset($options['attr']['type']);
		}
		
		if (isset($list_type) && $list_type == "history") {
			$item->item_wiki_page = $output_item['item_wiki_page'];
			$item_list = $item->selItems(1);
		}
		elseif (isset($list_type) && $list_type == "similar") {
			unset($item->item_wiki_page);
			if (isset($output_item['category_id'])) {
				$item->category_id = $output_item['category_id'];
			}
			$item_list = $item->selItems();
		}
		elseif (isset($list_type) && $list_type == "contents") {
			unset($item->item_wiki_page, $item->category_id);
			$item->order_by = "i.item_wiki_page";
			$item_list = $item->selItems();
		}
		else { //latest
			unset($item->item_wiki_page);
			$item->limit = 10;
			$item_list = $item->selItems();
		}
		
		
		// get the CSS class
        $css = $this->formatConf(' class="%s"', 'css');
        
        // start the HTML output
        $output = '<table cellpadding="2" cellspacing="0" border="0" ' . $css . '>';
        
        if (isset($item_list)) {
			foreach($item_list as $key => $i):
				if (!isset($output_item['item_id']) || $output_item['item_id'] != $i['item_id']) {
					$output .= '<tr>';
					$output .= '<td><a href="index.php?page=' . $i['item_wiki_page'] .'">' .$i['item_create_datetime'] .'</a><br /></td>';
					$output .= '<td>' . $i['item_title'] . '<br /></td>';
					$output .= '</tr>';
				}
			endforeach;
		}
		
        // end the table        
		$output .= "</table>";
        
        
        
        return $output;
    }
}
?>