<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// chart.php
// batchjob to create some charts of the activities in AM
// 30th November 2006, Sebastian Oblom


$path = dirname(__FILE__) . "/";

include $path . "../components/core/config/aroundme_core.config.php";


define ('WIDTH_24_HOUR_ACTIVITY', 350);
define ('HEIGHT_24_HOUR_ACTIVITY', 110);
define ('X_FACTOR_24_HOUR_ACTIVITY', 1.0);
define ('Y_FACTOR', 1.0);
define ('CHART_24_HOUR_ACTIVITY', '../' . $core_config['file']['dir'] . 'core/chart_24_hour_activity.png');

define ('WIDTH_PEOPLE_BY_LOCATION', 350);
define ('HEIGHT_PEOPLE_BY_LOCATION', 250);
define ('SCALE_FACTOR_PEOPLE_BY_LOCATION', 0.4);
define ('CHART_PEOPLE_BY_LOCATION', '../' . $core_config['file']['dir'] . 'core/chart_people_by_location.png');

define ('WIDTH_30_DAY_ACTIVITY', 350);
define ('HEIGHT_30_DAY_ACTIVITY', 110);
define ('CHART_30_DAY_ACTIVITY', '../' . $core_config['file']['dir'] . 'core/chart_30_day_activity.png');

$color           = array('backgroundcolor' => array ('red'   => 255,
													 'green' => 255,
													 'blue'  => 255),
						 'gridscolor'      => array ('red'   => 51,
						 							 'green' => 51,
						 							 'blue'  => 51),
						 'foregroundcolor' => array ('red'   => 244,
						 							 'green' => 148,
						 							 'blue'  => 178));


// SETUP DATABASE -----------------------------------------------------------------------
require_once($path . '../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];

	$chart           = ImageCreate(WIDTH_24_HOUR_ACTIVITY, HEIGHT_24_HOUR_ACTIVITY);
	$backgroundcolor = ImageColorAllocate($chart, $color['backgroundcolor']['red'], $color['backgroundcolor']['green'], $color['backgroundcolor']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $color['gridscolor']['red'], $color['gridscolor']['green'], $color['gridscolor']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $color['foregroundcolor']['red'], $color['foregroundcolor']['green'], $color['foregroundcolor']['blue']);

	$y_values        = array(); $i=0;
	while ($i < 25) { // we need to init $y_values
		array_push($y_values, array('hour' => $i++, 'nr_of_hours' => 0));
	}

	// We select the data needed for the image ----------------------------------------------
	$query = "
		SELECT HOUR(session_lastused) AS hour, 
		COUNT(HOUR(session_lastused)) AS nr_of_hours
		FROM " . $db->prefix . "_user_session
		GROUP BY HOUR(session_lastused)"
	;

	$result = $db->Execute($query);
	$max_val = 0;
			
	if (isset($result)) {
		while(!$result->EOF) {
			$max_val = $max_val >= $result->fields['nr_of_hours'] ? $max_val : $result->fields['nr_of_hours'];
			$y_values[$result->fields['hour']] = $result->fields;
			$result->moveNext();
		}
		$result->Close();
	}
	// ----------------------------------------------------------------------------------------
	
	
	// We construct the image -----------------------------------------------------------------
	$z  = intval(WIDTH_24_HOUR_ACTIVITY / 24);
	$f3 = (HEIGHT_24_HOUR_ACTIVITY - 10) / $max_val;

	for($i = 0; $i <= 23; $i++) {
		$x1 = $z*$i + 3;
		$x2 = $z*($i + 1) + 3;
	 	$y1 = isset($y_values[$i]['nr_of_hours']) ? Y_FACTOR * $y_values[$i]['nr_of_hours'] : 0;
	 	$y2 = isset($y_values[$i+1]['nr_of_hours']) ? Y_FACTOR * $y_values[$i+1]['nr_of_hours'] : 0;
		imageline($chart, $x1, HEIGHT_24_HOUR_ACTIVITY - $f3*$y1 - 10, $x2, HEIGHT_24_HOUR_ACTIVITY - $f3*$y2 - 10, $foregroundcolor);
	}
	
	// we draw the axis --------------------------------------
	imageline($chart, 1 + 3, 1, 1 + 3, HEIGHT_24_HOUR_ACTIVITY - 10, $gridscolor);
	imageline($chart, 1 + 3, HEIGHT_24_HOUR_ACTIVITY - 10, WIDTH_24_HOUR_ACTIVITY - 1 + 3, HEIGHT_24_HOUR_ACTIVITY - 10, $gridscolor);
	imageline($chart, 1 + 3, intval(HEIGHT_24_HOUR_ACTIVITY / 2) - intval(10 / 2), 5 + 3, intval(HEIGHT_24_HOUR_ACTIVITY / 2) - intval(10 / 2), $gridscolor);
	imageline($chart, 1 + 3, 1, 5 + 3, 1, $gridscolor);
		
	imagestring($chart, 1, 7, intval(HEIGHT_24_HOUR_ACTIVITY / 2) - intval(10 / 2), intval($max_val /2), $gridscolor);
	imagestring($chart, 1, 7, 1, $max_val, $gridscolor);
		
	for ($i = 0; $i <= 24; $i++) {
		if ($i != 0) {
			imageline($chart, $i*$z + 3, HEIGHT_24_HOUR_ACTIVITY - 10, $i*$z + 3, HEIGHT_24_HOUR_ACTIVITY - 3 - 10, $gridscolor);
		}
		if ($i == 0 || $i == 12 || $i == 24) {
			imagestring($chart, 1, $i*$z + 3, HEIGHT_24_HOUR_ACTIVITY - 10, $i, $gridscolor);
		}
	}
	// -------------------------------------------------------
	imagepng($chart, CHART_24_HOUR_ACTIVITY); 
	imageDestroy($chart);
	// ----------------------------------------------------------------------------------------
	
	
	$chart           = ImageCreate(WIDTH_PEOPLE_BY_LOCATION, HEIGHT_PEOPLE_BY_LOCATION);
	$backgroundcolor = ImageColorAllocate($chart, $color['backgroundcolor']['red'], $color['backgroundcolor']['green'], $color['backgroundcolor']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $color['gridscolor']['red'], $color['gridscolor']['green'], $color['gridscolor']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $color['foregroundcolor']['red'], $color['foregroundcolor']['green'], $color['foregroundcolor']['blue']);
	$grey            = ImageColorAllocate($chart, 241, 238, 240);
	$y_values        = array();
	
	
	// selecting values from the database -----------------------------------------------------
	$query = "
		SELECT l.location_name, count(l.location_id) as count_location 
		FROM " . $db->prefix . "_user u 
		INNER JOIN " . $db->prefix . "_user_location l 
		ON u.location_id=l.location_id 
		GROUP BY l.location_id 
		ORDER BY count_location DESC"
	;
	
	$result = $db->Execute($query);
	$counter = 0;
			
	if (isset($result)) {
		while(!$result->EOF && $counter < 20) {
			$y_values[] = $result->fields;
			$counter++;
			$result->moveNext();
		}
		$result->Close();
	}
	// ----------------------------------------------------------------------------------------
	$n = isset($y_values[0]) ? ceil(intval($y_values[0]['count_location'])/10)*10 : 1;
	$r = (WIDTH_PEOPLE_BY_LOCATION - SCALE_FACTOR_PEOPLE_BY_LOCATION * WIDTH_PEOPLE_BY_LOCATION)/$n;

	sort($y_values);
	
	if (count($y_values) != 0) {
		$space = intval(HEIGHT_PEOPLE_BY_LOCATION / count($y_values));
	}
	else {
		$space = HEIGHT_PEOPLE_BY_LOCATION;
	}
	
	
	// construct the chart --------------------------------------------------------------------
	for($i=0; $i < count($y_values); $i++) {
		$str = strlen($y_values[$i]['location_name']) > 16 ? substr($y_values[$i]['location_name'], 0, 16) . "..." : $y_values[$i]['location_name'];
		imagestring($chart, 2, 3, $i*$space - 3, $str, $gridscolor);
		imagefilledrectangle($chart, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), $i*$space, WIDTH_PEOPLE_BY_LOCATION, $i*$space + 3, $grey);
		imagefilledrectangle($chart, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), $i*$space, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION + $r*$y_values[$i]['count_location']), $i*$space + 3, $foregroundcolor);
	}
	
	// the axis and stuff
	imageline($chart, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), HEIGHT_PEOPLE_BY_LOCATION - 10, WIDTH_PEOPLE_BY_LOCATION, HEIGHT_PEOPLE_BY_LOCATION - 10, $gridscolor);
	imageline($chart, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), HEIGHT_PEOPLE_BY_LOCATION - 10, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), HEIGHT_PEOPLE_BY_LOCATION - 13, $gridscolor);
	imageline($chart, (intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION) + WIDTH_PEOPLE_BY_LOCATION)/2, HEIGHT_PEOPLE_BY_LOCATION-10, (intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION) + WIDTH_PEOPLE_BY_LOCATION)/2, HEIGHT_PEOPLE_BY_LOCATION - 13, $gridscolor);
	imageline($chart, WIDTH_PEOPLE_BY_LOCATION - 1, HEIGHT_PEOPLE_BY_LOCATION - 10, WIDTH_PEOPLE_BY_LOCATION - 1, HEIGHT_PEOPLE_BY_LOCATION - 13, $gridscolor);
	
	imagestring($chart, 0, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION), HEIGHT_PEOPLE_BY_LOCATION - 9, "0", $gridscolor);
	imagestring($chart, 0, WIDTH_PEOPLE_BY_LOCATION - 5 * strlen($n), HEIGHT_PEOPLE_BY_LOCATION - 9, $n, $gridscolor);
	imagestring($chart, 0, intval(WIDTH_PEOPLE_BY_LOCATION * SCALE_FACTOR_PEOPLE_BY_LOCATION + WIDTH_PEOPLE_BY_LOCATION)/2 - 5, HEIGHT_PEOPLE_BY_LOCATION - 9, $n/2, $gridscolor);
	
	
	imagepng($chart, CHART_PEOPLE_BY_LOCATION); 
	ImageDestroy($chart);
	
	// ------------------------------------------------------------------------------------------
	$chart           = ImageCreate(WIDTH_30_DAY_ACTIVITY, HEIGHT_30_DAY_ACTIVITY);
	$backgroundcolor = ImageColorAllocate($chart, $color['backgroundcolor']['red'], $color['backgroundcolor']['green'], $color['backgroundcolor']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $color['gridscolor']['red'], $color['gridscolor']['green'], $color['gridscolor']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $color['foregroundcolor']['red'], $color['foregroundcolor']['green'], $color['foregroundcolor']['blue']);
	$y_values        = array(); $i=0;
	
	while($i < 30) { // we need to init $y_values
		array_push($y_values, array('x' => ++$i, 'y' => 0));
	}

	
	// select some values from the database -----------------------------------------------------
	$query = "
		SELECT COUNT(distinct user_id) AS y, DAY(session_lastused) AS x
		FROM " . $db->prefix . "_user_session 
		GROUP BY DAY(session_lastused) ORDER BY session_lastused
		LIMIT 30"
	;

	$result = $db->Execute($query);

	if (isset($result->fields)) {
		$counter = $max_val = 0;
		while(!$result->EOF) {
			$y_values[$counter] = $result->fields;
			$max_val = $max_val >= $result->fields['y'] ? $max_val : $result->fields['y'];
			$result->moveNext();
			$counter++;
		}
		$result->Close();
	}
	// ------------------------------------------------------------------------------------------
	
	// draw the chart ---------------------------------------------------------------------------
	$space = 11;
	$s = 0.75 * HEIGHT_30_DAY_ACTIVITY / $max_val;
			
	for($i = 0; $i < count($y_values); $i++) {
		$x1 = $i * $space;
		$y1 = HEIGHT_30_DAY_ACTIVITY - 10 - intval($y_values[$i]['y'] * $s);
		$x2 = $i * $space + 6;
		$y2 = HEIGHT_30_DAY_ACTIVITY - 10;
		imagefilledrectangle($chart, $x1, $y1, $x2, $y2, $foregroundcolor);
 
	}

	
	imageline($chart, 0, HEIGHT_30_DAY_ACTIVITY - 10, WIDTH_30_DAY_ACTIVITY, HEIGHT_30_DAY_ACTIVITY - 10, $gridscolor);
			
	for($i=0; $i <= 30; $i+=5){
		imageline($chart, ($i-1) * $space + 3, HEIGHT_30_DAY_ACTIVITY - 10, ($i-1) * $space + 3, HEIGHT_30_DAY_ACTIVITY - 13, $gridscolor);
		imagestring($chart, 0, ($i-1) * $space + 1, HEIGHT_30_DAY_ACTIVITY - 9, -$i, $gridscolor);
	}

	imageline($chart, WIDTH_30_DAY_ACTIVITY - 1, 0, WIDTH_30_DAY_ACTIVITY - 1, HEIGHT_30_DAY_ACTIVITY - 10, $gridscolor);
	imageline($chart, WIDTH_30_DAY_ACTIVITY, 0, WIDTH_30_DAY_ACTIVITY - 5, 0, $gridscolor);
	imageline($chart, WIDTH_30_DAY_ACTIVITY, (HEIGHT_30_DAY_ACTIVITY - 10)/2, WIDTH_30_DAY_ACTIVITY - 5, (HEIGHT_30_DAY_ACTIVITY - 10)/2, $gridscolor);
	imagestring($chart, 0, WIDTH_30_DAY_ACTIVITY -10, 0, intval($max_val/0.75), $gridscolor);
	imagestring($chart, 0, WIDTH_30_DAY_ACTIVITY -10, (HEIGHT_30_DAY_ACTIVITY - 10)/2, intval($max_val/0.75/2), $gridscolor);


	imagepng($chart, CHART_30_DAY_ACTIVITY); 
	ImageDestroy($chart);
	// ------------------------------------------------------------------------------------------
	
	
	
	// database-cleanup --------------------
	$db->Close();
	// -------------------------------------
}
?>