<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class ICal {
	// CLASS FUNCTIONS
	// ICal
	// outputIcalFile
	
	function ICal() {
		
	}
	
	
	// outputIcalFile --------------------------------------------------------------------
	// output schedule item(s) as iCal file
	// Tom Calthrop - 20th May 2006
	//
	function outputIcalFile($data){
	
		$output = "BEGIN:VCALENDAR\n";
		$output .= "VERSION:2.0\n";
		$output .= "X-WR-CALNAME:". $this->calendar_title ."\n";
		$output .= "\n";
		
		foreach ($data as $key => $i):
			// schedule item is either an event or a todo
			if ($i['schedule_type_id'] == $this->schedule_config['type']['event']) { // event
				$output .= "BEGIN:VEVENT\n";
				$output .= "DTSTART;TZID=GMT+1T" . $i['schedule_start_datetime'] . "\n";
				$output .= "DTEND;TZID=GMT+1T" . $i['schedule_end_datetime'] . "\n";
				$output .= "LOCATION:" . $i['schedule_location'] . "\n";
				$output .= "SUMMARY:" . $i['schedule_title'] . "\n";
				// schedule item needs a unique ID in the iCal protocol
				$output .= "UID:AROUNDMe-". $i['schedule_id'] . "-@" . $_SERVER['HTTP_HOST'] . "\n";
				$output .= "DESCRIPTION:" . $i['schedule_synopsis'] . "\n";
				$output .= "END:VEVENT\n";
				$output .= "\n";
			}
			elseif ($i['schedule_type_id'] == $this->schedule_config['type']['task']) { // todo
				$output .= "BEGIN:VTODO\n";
				// schedule item needs a unique ID in the iCal protocol
				$output .= "UID:AROUNDMe-". $i['schedule_id'] . "-@" . $_SERVER['HTTP_HOST'] . "\n";
				$output .= "DTSTAMP;TZID=GMT+1T" . $i['schedule_create_datetime'] . "\n";
				$output .= "ORGANIZER:MAILTO". $i['user_id'] . "\n";
				$output .= "ATTENDEE;PARTSTAT=ACCEPTED:MAILTO:". $i['user_id'] . "\n";
				$output .= "DUE;TZID=GMT+1T" . $i['schedule_start_datetime'] . "\n";
				$output .= "STATUS:NEEDS-ACTION\n";
				$output .= "SUMMARY:" . $i['schedule_title'] . "\n";
				$output .= "SEQUENCE:2\n";
				$output .= "BEGIN:VALARM\n";
				$output .= "ACTION:AUDIO\n";
				$output .= "TRIGGER" . $i['schedule_start_datetime'] . "\n";
				$output .= "REPEAT:4\n";
				$output .= "DURATION:PT1H\n";
				$output .= "END:VALARM\n";
				$output .= "END:VTODO\n";
				$output .= "\n";
			}
			
		endforeach;
	
		$output .= "END:VCALENDAR\n";
		
		// prompt browser to save file.
		header('Content-Disposition: attachment; filename="AROUNDMe_iCal.ics"');
		echo $output;
		exit;
	} // EO outputIcalFile
}
?>