<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'grp_common.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');


//get count of each memberships role
$group_acs->group_id = $group_id;
$group_roles = $group_acs->getGroupRoles();
$group->member_status_id = $c_node['group']['member_status']['active'];

if (isset($group_roles)) {
    foreach($group_roles as $key => $i):
		$group->role_id = $i['role_id'];
		$group_roles[$key]['total_members'] = $group->getCountMembers();
	endforeach;
}



$wiki_path = "lib_view.php?group_id=" . $group->group_id . "&page=";
$wiki_new_path = "lib_edit.php?group_id=" . $group->group_id . "&page=";
$wiki_image_base = $c_node['dir']['asset_path'] . "group/";

require_once('class/Wiki/Wiki.php');
//wiki setup
$wiki = new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . $wiki_image_base);

$lang['txt_node_rules'] = readTxtFile($languageTextPath . 'node_rules.txt.php');
$lang['txt_node_rules'] = stripslashes($lang['txt_node_rules']);
$lang['txt_node_rules'] = $wiki->transform($lang['txt_node_rules'], 'Xhtml');

$output_group['group_rules'] = $wiki->transform($output_group['group_rules'], 'Xhtml');

	
//move to template
if (!empty($group_roles)) {
	$body->set('group_roles', $group_roles);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

include "inc/footer.inc.php";

?>
