<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";


//ACS check
if (!empty($_REQUEST['group_id'])) { // page under group section
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
    //ACS check
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['poll'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
else {
	if (!isset($me['user_id']) || !$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['poll'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
		header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
		exit;
	}
	unset ($group_id);
}


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');
require_once($languagePath . 'frm_view.lang.php');


//setup poll ---------------------------------------------------------------
require_once('class/Poll.class.php');
$poll = new Poll($db, null);


if (isset($_REQUEST['poll_id'])) {
	$poll->poll_id = $_REQUEST['poll_id'];
}

if (isset($group_id)) {
    $poll->group_id = $group_id;
}


//SETUP RSP ---------------------------------------------------------
require_once('class/Rsp.class.php');
$rsp = new Rsp($db, $c_node['rsp']['item_type']['poll']);
$rsp->user_id = $me['user_id'];

if (isset($group_id)) {
    $rsp->group_id = $group_id;
}


// SETUP BOOKMARKS ---------------------------------------------------------
require_once('class/Bookmark.class.php');
$bookmark = new Bookmark($db, $c_node['rsp']['item_type']['poll'], $me['user_id']);
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];


//RECEIVE POST AND PROCESS --------------------------------------------------
if (!empty($frmdata)) {
	if (!empty($frmdata['group_id'])) { // page under group section
		$wiki_path = "lib_view.php?group_id=" . $frmdata['group_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?group_id=" . $frmdata['group_id'] . "&page=";
	}
	else {
		$wiki_path = "lib_view.php?user_id=" . $me['user_id'] . "&page=";
		$wiki_new_path = "lib_edit.php?page=";
	}
	
	$wiki_image_base = "get_file.php?file=";
	
	require_once('class/Wiki/Wiki.php');
	$wiki = new Text_Wiki();
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', $wiki_path);
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', $wiki_new_path);
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);

	$frmdata['poll_question'] = htmlspecialchars($frmdata['poll_question']);

	if (isset($frmdata['preview'])) {
		$frmdata['poll_body'] = stripslashes($frmdata['poll_body']);
		$frmdata['poll_question'] = stripslashes($frmdata['poll_question']);
		$frmdata['poll_body_preview'] = $wiki->transform($frmdata['poll_body'], 'Xhtml');
		
		if (!isset($frmdata['rsp_public_featured'])) {
			$frmdata['rsp_public_featured'] = 0;
		}
		
		if (!empty($frmdata['rsp_node'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['node'], 'degree_id' => $frmdata['rsp_node'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_public'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['public'], 'rsp_featured' => $frmdata['rsp_public_featured']);
		}
		
		if (!empty($frmdata['rsp_group'])) {
			$frmdata['rsp'][] = array('level_id' => $c_node['rsp']['rsp_level']['group']['home']);
		}
		
		$output_poll = $frmdata;
		
		$display = "allow_edit";
	}
	elseif (isset($frmdata['save']) || isset($frmdata['save_go'])) {
		
		if (!empty($frmdata['poll_start_date'])) {
			if (!empty($frmdata['poll_start_time'])) {
				$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date'], $frmdata['poll_start_time']);
			}
			else {
				$frmdata['poll_start_datetime'] = $date->formatFormDateTime($frmdata['poll_start_date']);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(38, null, null);
		}
		
		if (!empty($frmdata['poll_end_date'])) {
			if (!empty($frmdata['poll_start_time'])) {
				$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date'], $frmdata['poll_end_time']);
			}
			else {
				$frmdata['poll_end_datetime'] = $date->formatFormDateTime($frmdata['poll_end_date']);
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array(39, null, null);
		}
		
		if (empty($frmdata['poll_question'])) {
			$GLOBALS['am_error_log'][] = array(37, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			//
			if (isset($frmdata['poll_id']) && $frmdata['poll_id'] > 0) {
				$poll->updatePoll($frmdata);
			}
			else { //we insert record
				$poll->user_id = $me['user_id'];
				$poll->insertPoll($frmdata);
			}
					
			if (empty($GLOBALS['am_error_log'])) {
				//insert into setup rsp
				if (!empty($frmdata['group_id'])) {
				    $temp['language_id'] = $output_group['language_id'];
				}
				else {
					$temp['language_id'] = $me['language_id'];
				}
				
				$temp['item_id'] = $poll->poll_id;
				//delete all
				$rsp->deleteRspItem($poll->poll_id);
				
				//insert node rsp entry
				if (!empty($frmdata['rsp_node'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['node'];
					if (!empty($frmdata['rsp_node_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if ($frmdata['rsp_node'] == "all" || !empty($frmdata['group_id'])) {
					    $temp['degree_id'] = "null";
					}
					else {
						$temp['degree_id'] = $frmdata['rsp_node'];
					}
					
					if($c_node['rsp']['node']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				if (isset($frmdata['rsp_group'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['group']['home'];
					
					if($output_group['group_rsp_auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}

					$rsp->insertRspItem($temp);
				}
				
				if (!empty($frmdata['rsp_public'])) {
				    $temp['level_id'] = $c_node['rsp']['rsp_level']['public'];
					
					if (!empty($frmdata['rsp_public_featured'])) {
					    $temp['rsp_featured'] = 1;
					}
					else {
						$temp['rsp_featured'] = "null";
					}
					
					if($c_node['rsp']['public']['auto_publish'] == 1) {
						$rsp->status_id = $c_node['rsp']['status']['live'];
					}
					else {
						$rsp->status_id = $c_node['rsp']['status']['pending'];
					}
					
					$rsp->insertRspItem($temp);
				}
				
				// add bookmark tracking
				$bookmark->item_id = $poll->poll_id;
				$bookmark->deleteBookmark();
				if (!empty($frmdata['ins_mark'])) {
					$bookmark->insertBookmark(1);
				}
				
				//setup statistics
				require_once('class/Statistic.class.php');
				$statistic = new Statistic($db, $c_node['rsp']['item_type']['poll'], $date);
				
				if (!empty($frmdata['group_id'])) { // page under group section
					unset($poll->user_id);
					$statistic->group_id = $frmdata['group_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group']['total_polls'];
				}
				else {
					$poll->user_id = $me['user_id'];
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['user']['total_polls'];
				}
				
				$statistic->setStatistic($poll->selPollCount());
				
				//get member blog stats
				if (!empty($frmdata['group_id'])) { // page under group section
					$statistic->user_id = $me['user_id'];
					$statistic->statistic_type_id = $c_node['statistic']['group_member']['total_polls'];
					$statistic->setStatistic($poll->selPollCount($me['user_id']));
				}
				
				if (isset($frmdata['save_go'])) {
					header("Location: pol_view.php?poll_id=" . $poll->poll_id . "&". strip_tags(SID));
					exit;
				}
				else {
					if (!empty($frmdata['group_id'])) { // page under group section
						header("Location: pol_edit.php?group_id=" . $frmdata['group_id'] . "&poll_id=" . $poll->poll_id . "&". strip_tags(SID));
						exit;
					}
					else {
						header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&". strip_tags(SID));
						exit;
					}
					
					
				}
			}
		}
		else { // something errored
			$output_poll = $frmdata;
		}
		
		$display = "allow_edit";
		
	}
	elseif (isset($_POST['delete_poll'])) {
		$poll->deletePoll();
		
		header("Location: pol_view.php?list=1&".SID);
		exit;
	}
	elseif (isset($_POST['insert_poll_option'])) {
		$poll->user_id = $me['user_id'];
		$poll->insertOption($frmdata['option_body']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	}
	elseif (isset($_POST['update_poll_option'])) {
		$poll->user_id = $me['user_id'];
		$poll->updateOption($frmdata['option_id'], $frmdata['option_body']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	
	}
	elseif (isset($_POST['delete_poll_option'])) {
		$poll->deleteOption($frmdata['option_id']);
		
		header("Location: pol_edit.php?poll_id=" . $poll->poll_id . "&".SID);
		exit;
	
	}
}
elseif (isset($_REQUEST['poll_id']) && $_REQUEST['poll_id'] > 0) {
	$output_poll = $poll->selPoll();
	
	if (!empty($output_poll['group_id'])) {
		// we check that I am in the group and that I have permissions to view
		$group_id = $output_poll['group_id'];
		include_once ('inc/header_group.inc.php');
		
		if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['poll'], $c_acs['arr_acs']['privilege']['add_item'])) { //resourece_id, Priv_id
			$display = "edit_poll";
		}
		else {
			unset($output_poll, $display);
		}
	}
	else {
		$display = "edit_poll";
	}
}
else {
	$display = "add_poll";
}


if (isset($poll->poll_id)) {

	//You can delete before any comments are added or votes are given
	$poll->user_id = $me['user_id'];
	$output_poll_usage = $poll->getUserPollParticipation();
	
	if (isset($_REQUEST['option_id'])) { //we edit an option
		$output_option = $_REQUEST['option_id'];
	}
}


// SETUP LIBRARY ---------------------------------------------------------
require_once('class/Library.class.php');
$library = new Library($db, null);

if (!empty($output_poll['group_id'])) {
	$file->group_id = $output_poll['group_id'];
	$library->group_id = $output_poll['group_id'];
	unset($file->user_id);
}
else {
	$file->user_id = $me['user_id'];
	unset($file->group_id);
}

$output_wikipages = $library->getPages();
$output_filenames = $file->getFiles();

//setup file ----------------------------------------------------------------
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
$file->type_ids[] = $c_node['file']['mime'][1]['suffix']; //jpg
$file->type_ids[] = $c_node['file']['mime'][2]['suffix']; //png
$file->type_ids[] = $c_node['file']['mime'][3]['suffix']; //gif

$output_images = $file->getFiles();


//format dates
if (isset($output_poll['poll_start_datetime'])) {
	$output_poll['poll_start_date'] = substr($output_poll['poll_start_datetime'], 0,10);
	$output_poll['poll_end_date'] = substr($output_poll['poll_end_datetime'], 0,10);
	$output_poll['poll_start_time'] = substr($output_poll['poll_start_datetime'], 11,15);
	$output_poll['poll_end_time'] = substr($output_poll['poll_end_datetime'], 11,15);
}
else {
	$output_poll['poll_start_date'] = date('Y-m-d');
	$output_poll['poll_end_date'] = date('Y-m-d');
	$output_poll['poll_start_time'] = date('H:i');
	$output_poll['poll_end_time'] = date('H:i');
}


if (isset($output_poll['poll_id'])) {
	//get bookmark
	$bookmark->item_id = $output_poll['poll_id'];
	$output_poll['bookmark'] = $bookmark->getBookmark(1);
}


//RSP items
if (!empty($output_poll['poll_id'])) {
	$output_poll['rsp'] = $rsp->selRspItem($output_poll['poll_id']);
}

if (!empty($output_poll['group_id']) || isset($group_id)) {
	// are we allowed to publish to the public? If yes we give temporary public publish permission
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['rsp'], $c_acs['arr_acs']['privilege']['allow_rsp_public'])) { //resource_id, Priv_id
		$c_acs['resource_privilege'][$c_acs['arr_acs']['resource']['node']['rsp']][] = $c_acs['arr_acs']['privilege']['allow_rsp_public'];
	}
	
	// are we allowed to publish to the node? If yes we give temporary node publish permission
	if ($group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['rsp'], $c_acs['arr_acs']['privilege']['allow_rsp_node'])) { //resource_id, Priv_id
		$c_acs['resource_privilege'][$c_acs['arr_acs']['resource']['node']['rsp']][] = $c_acs['arr_acs']['privilege']['allow_rsp_node'];
	}
}


//move to template
if (!empty($output_wikipages)) {
	$body->set('wikipages', $output_wikipages);
}

if (!empty($output_filenames)) {
	$body->set('filenames', $output_filenames);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_polls)) {
   $body->set('polls', $output_polls);
}

if (!empty($output_poll)) {
   $body->set('poll', $output_poll);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

if (!empty($output_poll_usage)) {
   $body->set('poll_usage', $output_poll_usage);
}

if (!empty($output_option)) {
   $body->set('option', $output_option);
}

if (!empty($output_images)) {
	$body->set('images', $output_images);
	$body->set('image_thumbs', $c_node['file']['image']['thumb']);
}

$body->set('languagePath', $languagePath);

$body->set('rspconfig', $c_node['rsp']);

include "inc/footer.inc.php";

?>
