<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

//ACS check
if (isset($_REQUEST['group_id'])) {
	$group_id = $_REQUEST['group_id'];
	include_once ('inc/header_group.inc.php');
	
	if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['channels'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
		header("Location: grp_view.php?group_id=" . $_REQUEST['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	require_once($languagePath . 'grp_common.lang.php');
}
elseif (!isset($rss_access_granted) && (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['channels'], $c_acs['arr_acs']['privilege']['allow_access']))) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}

//setup RSS parser (gathers and parses RSS feeds or channels)
require_once('class/LastRss.class.php');
$rss = new lastRSS($db);
$rss->cache_dir = 'cache/feed'; 
$rss->cache_time = 3600; // one hour


// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


// SETUP CHANNEL --------------------------------------------------------
require_once('class/Channel.class.php');
$channel = new Channel($db);


if (isset($group_id)) {
	$channel->group_id = $group_id;
	$output_my_channels = $channel->selChannels();
}
elseif (isset($me['user_id'])) {//get my channels
	$channel->user_id = $me['user_id'];
	$output_my_channels = $channel->selChannels();
}

//get the node channels
unset($channel->user_id);
$channel->rsp_item_type_id = $c_node['rsp']['item_type']['channel'];
$channel->rsp_level_id = $rsp_level_id;
$channel->rsp_status_id = $c_node['rsp']['status']['live'];
$channel->language_ids = $me['language_ids'];
$output_channels = $channel->selChannels();


//if we get a channel ID get the channel list else get the newests my channel
if (isset($_REQUEST['channel_id'])) {
	$output_channel = $channel->selChannel($_REQUEST['channel_id']);
}
elseif (empty($output_channel)) {
	$key = count($output_channels);
	
	if ($key>=1) {
		$output_channel = $output_channels[$key-1];
	}
}

//get the channel links
if (!empty($output_channel)) {
	if (!empty($output_channel['group_id'])) {
		require_once('class/Group.class.php');
		require_once($languagePath . 'grp_common.lang.php');
		require_once($languageArrayPath . 'arr_group.lang.php');
		$group = new Group($db, null);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_id = $output_channel['group_id'];
		$output_group = $group->getGroup();
		
		//setup acs
		$group_acs = new Acs(null, $db, $c_node['arr_acs']['role_type']['group']);
		$group_acs->group_id = $output_channel['group_id'];
		
		// if access not allowed so far, check that I have view permissions within group
		if (isset($me['user_id'])) {
			$group->user_id = $me['user_id'];
			$output_group['member'] = $group->getGroupMembership();
		}
		
		if (empty($output_group['member']['role_id'])) {
			// treat as a visitor to the group
			$output_group['member'] = $group_acs->getGroupRole(null, 1);
		}
		
		$group_acs->role_id = $output_group['member']['role_id'];
		
		
		if (!isset($allow_view) && $group_acs->checkPermission($c_acs['arr_acs']['resource']['group']['channels'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
			$allow_view = 1;
		}
		
		$channel->group_id = $output_channel['group_id'];
		
		$menu_section = "group";
	}
	else {
		$allow_view = 1;
		
		$menu_section = "magazine";
	}
	
	if (!isset($allow_view)) {
		unset($output_channel);
	}
}


if (!empty($output_channel)) {
	$output_channel['feed'] = $rss->get($output_channel['channel_url']);
}


//move vars to template
if (!empty($output_channels)) {
	$body->set('channels', $output_channels);
}

if (!empty($output_my_channels)) {
	$body->set('my_channels', $output_my_channels);
}

if (!empty($output_channel)) {
	$body->set('channel', $output_channel);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
	$tpl->set('group', $output_group);
}

include "inc/footer.inc.php";

?>