<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


/*
* auth user
* check current vote
* if current vote != option_id
* remove all defaults
* insert vote and set as default
* return to page
*
* Tom Calthrop, 13th May 2004
*/

include "config/config_aroundme.inc.php";

require_once('class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($c_node['db']['driver']);
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


session_start();

if (isset($_POST['option_id'])) {
    //setup data
	$option_id = $_POST['option_id'];
	$user_id = $_SESSION['s_user_id'];

	//setup poll
	require_once('class/Poll.class.php');
	$poll = new Poll($db, null);
	$poll->poll_id = $_POST['poll_id'];
	$poll->user_id = $user_id;
	
	$current_answer = $poll->pollUserCurrentVote();

	if (isset($current_answer) && $current_answer != $option_id) {
		
		$poll->updateAnswer($option_id);
	}
}

header("Location: " . $_POST['return_url']."&".strip_tags(SID));
exit;

?>