<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$menu_section = "magazine";

include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_category.lang.php');


if (isset($_REQUEST['blog_id'])) {
    $blog_id = $_REQUEST['blog_id'];
}

if (isset($_REQUEST['subject_id'])) {
    $subject_id = $_REQUEST['subject_id'];
}

if (isset($_REQUEST['poll_id'])) {
    $poll_id = $_REQUEST['poll_id'];
}

if (isset($_REQUEST['library_id'])) {
    $library_id = $_REQUEST['library_id'];
}

if (isset($_REQUEST['section_id'])) {
    $section_id = $_REQUEST['section_id'];
}

//setup file
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][2]['name'];


//setup comment
require_once($c_node['dir']['class_path'] . 'Comment.class.php');
$comment = new Comment($db, null, $date);
$comment->user_id = $me['user_id'];
if (isset($group_id)) {
    $comment->group_id = $group_id;
}


//setup Wiki
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');



//process requests
if (isset($_POST['preview'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
	$output_comment['display_comment_body'] = nl2br(htmlspecialchars($output_comment["comment_body"], ENT_QUOTES));
	$output_comment['comment_body'] = str_replace ('"', '&quot;', $output_comment['comment_body']);

	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	$comment->item_id = $_REQUEST['comment_item_id'];
	$comment->user_id = $me['user_id'];

	if (isset($blog_id)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		$link = "blog_id=". $blog_id;
	}
	elseif (isset($subject_id)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		$link = "subject_id=". $subject_id;
	}
	elseif (isset($poll_id)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		$link = "poll_id=". $poll_id;
	}
	elseif (isset($library_id)) {
		$comment->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		$link = "library_id=". $library_id;
	}


	$comment->insertComment($frmdata);

	if (empty($GLOBALS['am_error_log'])) {
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $date);

		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];

		$statistic->user_id = $me['user_id'];
		$comment->user_id = $me['user_id'];
		unset($comment->item_id, $comment->rsp_item_type_id);

		$statistic->setStatistic($comment->getCommentCount());

		//goto the item
		return header("Location: mag_item.php?" . $link . "&" . SID);
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $frmdata;
	$output_comment['comment_body'] = stripslashes($output_comment['comment_body']);
}

if (isset($blog_id)) {
	require_once($c_node['dir']['class_path'] . 'Blog.class.php');
	$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
	$blog->blog_id = $blog_id;
	$output_blog = $blog->getBlog();

	if (!empty($output_blog['group_id'])) { // page under group section
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=group/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', 'get_file.php?file=group/');
	}
	else {
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=user/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', 'get_file.php?file=user/');
	}

	$output_blog['blog_body_display'] = $wiki->transform($output_blog['blog_body'], 'Xhtml');

	$comment->item_id = $blog_id;
	$comment->user_id = $output_blog['user_id'];
	$output_comments = $comment->selComments($blog_id);

	if (isset($output_blog['user_id'])) {
		$user->user_id = $output_blog['user_id'];
    	$output_author = $user->getProfile();
	}

	if (!empty($output_blog['blog_allow_comments'])) {
		$allow_add_comment = true;
	}
}


if (isset($subject_id)) {
	require_once($c_node['dir']['class_path'] . 'Forum.class.php');
	$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);
	$forum->subject_id = $subject_id;
	$output_subject = $forum->getSubject();

	$comment->item_id = $subject_id;
	$comment->user_id = $output_subject['user_id'];
	$output_comments = $comment->selComments($subject_id);

	if (isset($output_subject['user_id'])) {
		$user->user_id = $output_subject['user_id'];
    	$output_author = $user->getProfile();
	}

	if (empty($output_subject['subject_locked'])) {
		$allow_add_comment = true;
	}
}


if (isset($poll_id)) {
	require_once($c_node['dir']['class_path'] . 'Poll.class.php');
	$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
	$poll->poll_id = $poll_id;
	$output_poll = $poll->getPoll();
	$output_poll['current_answer'] = $poll->pollUserCurrentVote($me['user_id']);

	if (isset($output_poll)) {
		$output_poll_history = $poll->pollUserVoteHistory($me['user_id']);
	}

	$comment->item_id = $poll_id;
	$output_comments = $comment->selComments($poll_id);

	//get users vote for each comment
	if (isset($output_comments)) {
		foreach($output_comments as $key => $i):
			$output_comments[$key]['vote'] = $poll->pollUserVoteHistory($i['user_id']);
		endforeach;
	}

	if (isset($output_poll['user_id'])) {
		$user->user_id = $output_poll['user_id'];
    	$output_author = $user->getProfile();
	}

	if (!empty($output_poll)) {
		$datetime = date("Y-m-d H:i:s");
		if ($output_poll['poll_start_datetime'] < $datetime && $output_poll['poll_end_datetime'] > $datetime) {
		    $allow_add_comment = true;
		}
	}
}


if (isset($library_id)) {
	require_once($c_node['dir']['class_path'] . 'Library.class.php');
	$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
	$library->library_id = $library_id;
	$output_library_item = $library->getPageID();

	if (!empty($output_library_item['group_id'])) { // page under group section
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=group/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', 'get_file.php?file=group/');
	}
	else {
	    $wiki->setRenderConf('xhtml', 'image', 'base', 'get_file.php?file=user/');
		$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', 'get_file.php?file=user/');
	}

	$output_library_item['library_body'] = $wiki->transform($output_library_item['library_body'], 'Xhtml');
	$output_library_item['display_library_create_datetime'] = $date->formatDate($output_library_item['library_create_datetime'], 1);

	$comment->item_id = $library_id;
	$comment->user_id = $output_library_item['user_id'];
	$output_comments = $comment->selComments($library_id);

	if (isset($output_library_item['user_id'])) {
		$user->user_id = $output_library_item['user_id'];
    	$output_author = $user->getProfile();
	}

	if (!empty($output_library_item['library_allow_comments'])) {
		$allow_add_comment = true;
	}
}


//move to template
if (!empty($output_blog)) {
	$body->set('blog', $output_blog);
	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?blog_id=' . $output_blog['blog_id']);
	$tpl->set('toolbar_printc', 'print_item.php?blog_id=' . $output_blog['blog_id'] . '&amp;inc_comment=1');

	if (isset($_REQUEST['group_id'])) {
		$tpl->set('toolbar_bookmark_url', 'blg_item.php?group_id=' . $_REQUEST['group_id'].'&amp;blog_id=' . $output_blog['blog_id']);
	}
	else {
		$tpl->set('toolbar_bookmark_url', 'blg_item.php?blog_id=' . $output_blog['blog_id']);
	}
}

if (!empty($output_subject)) {
	$body->set('subject', $output_subject);
	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?subject_id=' . $output_subject['subject_id']);
	$tpl->set('toolbar_printc', 'print_item.php?subject_id=' . $output_subject['subject_id'] . '&amp;inc_comment=1');

	if (isset($_REQUEST['group_id'])) {
		$tpl->set('toolbar_bookmark_url', 'frm_item.php?group_id=' . $_REQUEST['group_id'].'&amp;subject_id=' . $output_subject['subject_id']);
	}
	else {
		$tpl->set('toolbar_bookmark_url', 'frm_item.php?subject_id=' . $output_subject['subject_id']);
}
}

if (!empty($output_poll)) {
	$body->set('poll', $output_poll);
	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?poll_id=' . $output_poll['poll_id']);
	$tpl->set('toolbar_printc', 'print_item.php?poll_id=' . $output_poll['poll_id'] . '&amp;inc_comment=1');

	if (isset($_REQUEST['group_id'])) {
		$tpl->set('toolbar_bookmark_url', 'pol_item.php?group_id=' . $_REQUEST['group_id'].'&amp;poll_id=' . $output_poll['poll_id']);
	}
	else {
		$tpl->set('toolbar_bookmark_url', 'pol_item.php?poll_id=' . $output_poll['poll_id']);
}
}

if (!empty($output_library_item)) {
	$body->set('library', $output_library_item);

	//setup print options
	$tpl->set('toolbar_print', 'print_item.php?library_id=' . $output_library_item['library_id']);
	$tpl->set('toolbar_printc', 'print_item.php?library_id=' . $output_library_item['library_id'] . '&amp;inc_comment=1');

	if (isset($_REQUEST['group_id'])) {
		$tpl->set('toolbar_bookmark_url', 'lib_item.php?group_id=' . $_REQUEST['group_id'].'&amp;library_id=' . $output_library_item['library_id']);
	}
	else {
		$tpl->set('toolbar_bookmark_url', 'lib_item.php?library_id=' . $output_library_item['library_id']);
	}
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_author)) {
	$body->set('author', $output_author);
}

if (isset($allow_add_comment)) {
	$body->set('allow_add_comment', $allow_add_comment);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($output_poll_history)) {
	$body->set('poll_history', $output_poll_history);
}

$template_pageLink = $lang['txt_magazine_name'];
include "inc/footer.inc.php";
?>
