<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "user";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['s_homepage'] . "?" . SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


//setup useradmin (extends user)
require_once($c_node['dir']['class_path'] . 'User.class.php');
require_once($c_node['dir']['class_path'] . 'UserAdmin.class.php');
$user = new UserAdmin($db, $date);



//process requests
if (isset($_POST['update_user'])) {
	$data['user_file_allocation'] = $data['user_file_allocation']*1000;
	$user->user_id = $data['user_id'];
	$user->updateAdminUser($data);
	
	if (empty($user->log)) {
		return header("Location: node_user.php?user_id=" . $data['user_id'] . "&amp;" . SID);
		exit;
	}
	
	
}
elseif (isset($_REQUEST['edit_user'])) {
	$user->user_id = $_REQUEST['user_id'];
	$output_user = $user->getUser();
	
	$display = "edit_user";
}
elseif (isset($_REQUEST['user_id'])) {
	$user->user_id = $_REQUEST['user_id'];
	$output_user = $user->getUser();
	$output_profile = $user->getProfile();
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	elseif (isset($output_profile)) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}

	$display = "view_user";
}
else {
	$output_users = $user->getAllUsers();
}


//trim roles to only include user roles
if (isset($lang['arr_acs']['role'])) {
    foreach($lang['arr_acs']['role'] as $key => $i):
		if (isset($c_acs['section_role'][$c_acs['arr_section']['user']])) {
   			foreach($c_acs['section_role'][$c_acs['arr_section']['user']] as $key1 => $r):
				if ($key == $r) {
				  $roles[$key] = $i;
				}
			endforeach;
		}
	endforeach;
	$lang['arr_acs']['role'] = $roles;
}






//move to template
if (!empty($output_users)) {
	$body->set('users', $output_users);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

include "inc/footer.inc.php";

?>
