<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

class Cms {
	// CLASS FUNCTIONS
	// Cms
	// getCmsItems
	// insertCmsItem
	// deleteCmsItem
	// updateCmsItem
	
	
	
	// Cms --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 10th December 2004
	//
	function Cms($db, $section_id){
		$this->db = $db;
		$this->section_id = $section_id;
	}//EO Cms
	
	
	
	// getCmsItems --------------------------------------------------------------------
	// return array of type ids
	// tom calthrop - 10th December 2004
	//
	function getCmsItems() {
		$query = "
			SELECT item_id, cms_sticky, status_id 
			FROM " . $this->db->prefix . "_cms  
			WHERE "
		;
		
		if (isset($this->section_id)) {
			$query .= "section_id=" . $this->section_id . " and ";
		}
		
		if (isset($this->section_item_id)) {
			$query .= "section_item_id=" . $this->section_item_id . " and ";
		}
		
		if (isset($this->cms_status_id)) {
			$query .= "status_id=" . $this->cms_status_id . " and ";
		}
		
		if (isset($this->cms_item_type_id)) {
			$query .= "cms_item_type_id=" . $this->cms_item_type_id . " and ";
		}
		
		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}
		
		$query .= "1=1 order by cms_publish_datetime desc";
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getCmsItems class=Cms.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getCmsItems
	
	
	
	// insertCmsItem --------------------------------------------------------------------
	// inserts an item
	// tom calthrop - 8th Jan 2004
	//
	function insertCmsItem($data) {
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		
		if (empty($data['genre_id'])) {
		    $data['genre_id'] = "null";
		}
		
		$query = "
			INSERT INTO " . $this->db->prefix . "_cms (
			section_id, 
			section_item_id, 
			item_id, 
			cms_item_type_id, 
			cms_publish_datetime, 
			status_id, 
			level_id, 
			language_id, 
			genre_id
			) values (
			" . $this->section_id . ",
			" . $this->section_item_id . ",
			" . $data['item_id'] . ",
			" . $this->cms_item_type_id . ",
			" . $datetime . ",
			" . $data['status_id'] . ",
			" . $data['level_id'] . ",
			" . $data['language_id'] . ",
			" . $data['genre_id'] . ")"
		;
		
		$result = $this->db->Execute($query);

		if (empty($result->fields)) {
			$error_info = "function=insertCmsItem class=Cms.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertCmsItem
	
	
	
	// deleteCmsItem --------------------------------------------------------------------
	// deletes cms item(s)
	// tom calthrop - 26th December 2004
	//
	function deleteCmsItem($del_arr = null) {
		
		if (isset($del_arr)) {
		    $rownums = count($del_arr);
		}
		else {
		    $del_arr = array($this->item_id);
		}
		
		for ($i=0; $i < $rownums; $i++) {
		    $query = "
				DELETE FROM " . $this->db->prefix . "_cms 
				WHERE 
				section_id=" . $this->section_id . " and "
			;
			
			if (isset($this->section_item_id)) {
			    $query .= "section_item_id=" . $this->section_item_id . " and ";
			}
			
			$query .= "
				cms_item_type_id=" . $this->cms_item_type_id . " and 
				level_id=" . $this->level_id . " and 
				item_id=" . $del_arr[$i]
			;
			
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=deleteCmsItem class=Cms.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteCmsItem
	
	
	
	// updateCmsItem --------------------------------------------------------------------
	// updates cms item(s)
	// tom calthrop - 26th December 2004
	//
	function updateCmsItem($status_id, $sticky = null) {
		
		if (isset($sticky)) {
		    $sticky = 1;
		}
		else {
		    $sticky = "null";
		}
		
		$query = "
			UPDATE " . $this->db->prefix . "_cms SET 
			status_id=" . $status_id . ", 
			cms_sticky=" . $sticky . " 
			WHERE "
		;
		
		if (isset($this->section_item_id)) {
			$query .= "section_item_id=" . $this->section_item_id . " and ";
		}
		
		
		$query .= "
			section_id=" . $this->section_id . " and 
			cms_item_type_id=" . $this->cms_item_type_id . " and 
			level_id=" . $this->level_id . " and 
			item_id=" . $this->item_id
		;
			
		$result = $this->db->Execute($query);
		
		if (empty($result)) {
			$error_info = "function=updateCmsItem class=Cms.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
		
	} //EO updateCmsItem
}

?>
