<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
require_once($c_node['dir']['class_path'] . 'Statistic.class.php');


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');


//setup file
$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	

//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');
$wiki->setRenderConf('xhtml', 'shockwaveflash', 'base', $c_node['dir']['asset_path'] . 'user/');


//block or unblock user
if (isset($_REQUEST['block'])) {
    $display = "block";
}
elseif (isset($_REQUEST['unblock'])) {
	$sn->user_id = $me['user_id'];
    $user_blocked = $sn->unSetBlockUser($user_id, 'unblock');
}
elseif (isset($_POST['set_block'])) {
    $sn->user_id = $me['user_id'];
	$user_blocked = $sn->setBlockUser($user_id, $data['block_description']);
	//rebuild social network
	$_SESSION['s_social_network'] = $sn->createNetwork();
	$sn->updateSnStatistics();
	

	//refresh this page to show new status
	header("Location: sn_profile.php?user_id=" . $_POST['user_id']."&".SID);
	exit;
}
else {
	if ($sn->getBlockStatus($user_id)) {
		$display = "blocked";
	}
}


$output_profile['profile_summary'] = $wiki->transform($output_profile['profile_summary'], 'Xhtml');
	

//setup file
if (isset($output_profile['file_id'])) {
	$file->file_id = $output_profile['file_id'];
	$output_profile['image'] = $file->getFileRecord();
}
elseif (isset($output_profile)) {
	$output_profile['image']['file_title'] = "";
	$output_profile['image']['file'] = $file->noimage;
}

//setup statistics
$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
$statistic->user_id = $user_id;
$output_statistic = $statistic->getStatistics();


//get the relationships
$output_relationship_paths = $sn->getDegreePaths($user_id);

if (!empty($output_relationship_paths)) {
	foreach($output_relationship_paths as $key => $r):
		foreach($r['relation'] as $key => $i):
			$user->user_ids[] = $i;
		endforeach;
	endforeach;
}
$output_relationship_profiles = $user->getProfiles();



//move to template
if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship_paths)) {
	$body->set('relationship_paths', $output_relationship_paths);
}

if (!empty($output_relationship_profiles)) {
	$body->set('relationship_profiles', $output_relationship_profiles);
}

if (!empty($output_statistic)) {
	$body->set('user_statistic', $output_statistic);
}

if (!empty($user_blocked)) {
	$body->set('user_blocked', $user_blocked);
}

if (!empty($degree_path['degree'])) {
	$body->set('degree_id', $degree_path['degree']);
}



if (!empty($display)) {
	$body->set('display', $display);
}

$template_pageLink =  $lang['txt_profile'];
$template_pageLinkNote = $lang['txt_profile'] . ": " . $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
