<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_sn.inc.php";


require_once($c_node['dir']['class_path'] . 'Library.class.php');
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');
require_once($c_node['dir']['class_path'] . 'Comment.class.php');



if (isset($_REQUEST['page'])) {
	$page = $_REQUEST['page'];
}

if (isset($_REQUEST['library_id'])) {
	$library_id = $_REQUEST['library_id'];
}

if (isset($_REQUEST['history_library_id'])) {
	$history_library_id = $_REQUEST['history_library_id'];
}



//library setup
$library = new Library($db, $c_acs['arr_section']['user'], $date, $file);
$library->section_item_id = $user_id;
$library->degree_id = $degree_path['degree'];


//wiki setup
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'sn_library.php?user_id=' . $user_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'sn_library_edit.php?user_id=' . $user_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');

/*
//ACS check - can we edit the library - if we are not a member we turn off the ability to make new links
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_library'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', ''); // turn off the ability to link pages
	$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', '#'); // turn off the ability to create new pages
}
*/

// set an array of pages that exist in the library
$pages = $library->getPages();
$wiki->setRenderConf('xhtml', 'wikilink', 'pages', $pages);


//setup comment
$comment = new Comment($db, $c_node['cms']['item_type']['user_library'], $date);
$comment->section_item_id = $user_id;
$comment->user_id = $user_id;
	
	
//process requests
if (isset($_POST['preview'])) {
	$output_comment = $data;
	$output_comment['display_comment_body'] = htmlspecialchars(nl2br($output_comment["comment_body"]));
	
	$display = "preview_comment";

}
elseif (isset($_POST['insert'])) {
	
	$comment->item_id = $library_id;
	$comment->insertComment($data);
		
	if (empty($GLOBALS['am_error_log'])) {
		//update user stats
		//setup statistics
		require_once($c_node['dir']['class_path'] . 'Statistic.class.php');
		$statistic = new Statistic($db, $c_acs['arr_section']['user'], $date);
		$statistic->section_item_id = $user_id;
		//update stats
		
		$statistic->statistic_type_id = $c_node['statistic']['user']['total_comments'];
		$statistic->section_id = $c_acs['arr_section']['user'];
		$group->user_id = $user_id;
		$statistic->setStatistic($comment->getCommentCount());
		
		//goto the subject
		return header("Location: sn_library.php?user_id=". $user_id . "&library_id=". $library_id . "&" . SID);
		exit;
	}
}
elseif (isset($_POST['edit_again'])) {
	$output_comment = $data;
}


if (isset($_REQUEST['contents'])) {

	$output_contents = $library->getContents();

	$display = "contents";

}
elseif (isset($history_library_id)) {
	$output_history = $library->getHistory($history_library_id);

	$display = "history";
}
elseif (isset($library_id)) {
	$output_library = $library->getPageID($library_id);

	//find out if this is the newest article
	$newest_doc = $library->getPageName($output_library['library_page_name']);

	if ($output_library['library_id'] == $newest_doc['library_id']) {
	    $newest = true;
	}

}
elseif (isset($page)) {
	$output_library = $library->getPageName($page);
	$newest = true;
}
else {
	$output_library = $library->getPageDefault();
	$newest = true;
}

if (isset($output_library['library_id'])) {

	$library_id = $output_library['library_id'];
	
	$library->user_id = $me['user_id'];
	$library->library_page_name = $output_library['library_page_name'];
	
	//setup bookmarks
	$bookmark = new Bookmark($db, $c_node['cms']['item_type']['user_library'], $date, $user_id);
	$bookmark->item_id = $library_id;
	
	
	//watching
	$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
	//set or unset bookmarks
	if (isset($_REQUEST['watch'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unwatch'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$output_library['bookmark']['watch'] = 1;
	}

	//recommended
	$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
	//set or unset bookmarks
	if (isset($_REQUEST['recommend'])) {
		$bookmark->insertBookmark();
	}
	elseif (isset($_REQUEST['unrecommend'])) {
		$bookmark->deleteBookmark();
	}
	//get and update bookmark
	if ($bookmark->getBookmark()) {
		$bookmark->updateBookmark();
		$output_library['bookmark']['recommend'] = 1;
	}

	//Parser library
	$output_library['library_body'] = $wiki->transform($output_library['library_body'], 'Xhtml');
	
	
	$comment->item_id = $library_id;
	$output_comments = $comment->getComments($library_id, 1);

}


//get library image
if (isset($output_library['file_id'])) {
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	$file->file_id = $output_library['file_id'];
	$output_library['image'] = $file->getFileRecord();
}



//move to template
if (!empty($output_contents)) {
	$body->set('contents', $output_contents);
}

if (!empty($output_history)) {
	$body->set('history', $output_history);
}

if (!empty($newest)) {
	$body->set('newest', $newest);
}

if (!empty($output_comments)) {
	$body->set('comments', $output_comments);
}

if (!empty($output_comment)) {
	$body->set('comment', $output_comment);
}

if (!empty($output_library)) {
	$body->set('library', $output_library);
	$template_pageLink = $lang['txt_library'];
	$template_pageLinkNote = $output_library['library_title'];
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

if (!empty($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

if (!empty($display)) {
	$body->set('display', $display);
}

$template_pageLink = $lang['txt_library'];
$template_pageLinkNote = $output_profile['profile_nic'];

include "inc/footer.inc.php";

?>
