<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");



if (isset($_POST['search'])) {
	// search string should be over 3 chars long
	if (strlen(trim($_POST['search_text'])) < 3) {
		$GLOBALS['am_error_log'][] = array('search_size');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$search_text = trim($_POST['search_text']);
		
		$query = "
			SELECT DISTINCT b.blog_id, b.blog_title, e.entry_title, e.entry_id, 
			e.entry_synopsis, e.entry_create_datetime, e.entry_body 
			FROM " . $db->prefix . "_blog b," . $db->prefix . "_blog_entry e 
			WHERE 
			b.blog_id=e.blog_id AND 
			(b.blog_title like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			b.blog_synopsis like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			e.entry_title like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			e.entry_synopsis like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . " OR 
			e.entry_body like " . $db->qstr("%" . $search_text . "%", get_magic_quotes_gpc()) . ")"
		;
		
		$query .= " order by e.entry_create_datetime desc";
		
		$result = $db->Execute($query);
		
		$output_search = array();
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$temp = $result->fields;
				
				$temp['blog_title'] = searchTextFormat($search_text, $temp['blog_title']);
				$temp['entry_title'] = searchTextFormat($search_text, $temp['entry_title']);
				$temp['entry_synopsis'] = searchTextFormat($search_text, $temp['entry_synopsis']);
				$temp['entry_body'] = searchTextFormat($search_text, $temp['entry_body']);
				
				array_push($output_search, $temp);
				$result->MoveNext();
			}
		}
		
		$body->set('blogs', $output_search);
	}
}
elseif (isset($_REQUEST['blog_id'])) {
	// get the entries for a blog
	$output_entries = $blog->selEntries($_REQUEST['blog_id']);
}
elseif (isset($_REQUEST['tag'])) {
	$query = "
		SELECT b.blog_id, b.blog_title, e.entry_synopsis, 
		e.entry_title, e.entry_id 
		FROM " . $db->prefix . "_blog b," . $db->prefix . "_blog_entry e," . $db->prefix . "_tag t
		WHERE 
		b.blog_id=e.blog_id AND 
		t.module_id=" . $core_config['module_id']['blog'] . " AND
		(t.item_id=b.blog_id OR t.item_id=e.entry_id) AND 
		t.tag_body like " . $db->qstr("%" . $_REQUEST['tag'] . "%", get_magic_quotes_gpc())
	;
	
	$query .= " order by e.entry_create_datetime desc";
	//echo $query;
	$result = $db->Execute($query);
	
	$output_search = array();
	
	if (isset($result->fields)) {
		while (!$result->EOF) {
			$temp = $result->fields;
			array_push($output_search, $temp);
			$result->MoveNext();
		}
	}
	
	$body->set('tags', $output_search);
	
}
else {
	$body->set('display', 'intro');
}

if (isset($output_entries)) {
	$body->set('entries', $output_entries);
}

?>
