# AAMfP: a simple (Personal) Kanban metrics spreadsheet #
Copyright © 2017, 2018, 2019 Marco Bresciani.	

![Creative Commons
License](https://i.creativecommons.org/l/by-sa/4.0/80x15.png) *AAMfP: a
simple (Personal) Kanban metrics spreadsheet* by *Marco Bresciani* is
licensed under a [Creative Commons Attribution-ShareAlike 4.0
International License](http://creativecommons.org/licenses/by-sa/4.0/).

Ideas, contributions, issues, enhancements, ... are all welcome,
following the [Contributor Covenant Code of
Conduct](https://www.contributor-covenant.org/).

---

## Download ##

Current version is **v.10.2.5-beta** in
[zip](https://bitbucket.org/marcobresciani/aamfp/get/v.10.2.5-beta.zip),
[tar.gz](https://bitbucket.org/marcobresciani/aamfp/get/v.10.2.5-beta.tar.gz),
[tar.bz2](https://bitbucket.org/marcobresciani/aamfp/get/v.10.2.5-beta.tar.bz2)
format, or find all versions and download options from the
[Downloads](https://bitbucket.org/marcobresciani/aamfp/downloads/) menu.

---

## Intro ##
Improve your daily work and activities with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some flow metrics as described in the book [Actionable Agile
Metrics for Predictability](https://leanpub.com/actionableagilemetrics)
(and compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool).

### Visualize your work ###
The project also contains contains PDF and ODG (LibreOffice Draw)
versions of an [A3 format](https://en.wikipedia.org/wiki/ISO_216)
printable Personal Kanban board with **Backlog**, **Next**,
**In-progress** and **Done** columns. Feel free to use it to visualize
your activities!

This Kanban board uses **Unifont** by Unifoundry for text purposes.

Copyright (C) 1998-2018 Roman Czyborra, Paul Hardy, Qianqian Fang,
Andrew Miller, Johnnie Weaver, David Corbett, et al. License GPLv2+: GNU
GPL version 2 or later <http://gnu.org/licenses/gpl.html> with the GNU
Font Embedding Exception.

### Limit your work-in-progress ###
Remember to add your WIP limit to each of the columns in the board
above, to be sure to properly apply Kanban concepts and obtain real
improvements.

----

## Usage ##
> Complete, detailed usage instructions and data explanations can be
found in the [Usage](USAGE.md) file.

Briefly: the only sheet you need to work on is the *Activities* sheet
where you need to add, for each activity, the dates when such activities
have changed state. **CoS** (Class of Service) and **WIT** (Work Item
Type) column values are not mandatory.

Please note that *Activities* sheet already contains some data. Those
are example data to show you how to use and write them. Feel free to
remove them.

*While bug #6 is open*, when an activity has to be
dropped/cancelled/abandoned/… for any reason, you just have to write
such cancellation date in all remaining columns cells and also write the
same date in the **Deleted** column. With this, the activity will be
properly identified as deleted.

> In order to have correct metrics, chart, and data *you* have to keep
the *Activities* sheet rows in the correct order. Specifically, select
the table and apply the following sorting criteria (all crescent order):
**Done**, **In-progress**, **Next**, **Deadline**, **Backlog**, **ID**.
Once the column are ordered in this way, you can scroll all other sheets
where you can find the metrics and charts properly computed and
rendered.

**Deadline** column value is optional and the content is automatically
and conditionally formatted. Deadline is:
 
 * today, red cell;
 * this week, orange cell;
 * this month, yellow cell;
 * next month, green cell.
 * Expired completed activity, red text.

The whole *Activities* sheet is compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool (see [Format for Data
File](https://www.actionableagile.com/format-data-file/)): simply export
*Activities* sheet as CSV (select comma (**,**) as cell separator and
quotes (**"**) for fields) and then import it in the tool.

----

## References ##
For the **Kanban** method starts from here:
[What is Kanban | Lean Kanban](https://leankanban.com/project/wkanban/)
and the [Essential Kanban Condensed
Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/)
and [Personal Kanban: The Book | Personal
Kanban](http://personalkanban.com/pk/book/).

For more details on metrics read the book [Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

## Thanks ##
Thanks to:
* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
[#1](https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting).

----

## History ##

| VERSION |   DATE    | DESCRIPTION |
|:-------:|:---------:|:------------|
|    ?    |    ?      |Solve bug #6. Change "cancelled activities" management.|
|v.10.2.x|   SOON    |MINOR: add lead time stacked bar chart.|
|[v.10.2.5-beta](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.2.5-beta)|2019-01-04|PATCH: Use proper copyright notice for Unifont.|
|[v.10.2.4-beta](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.2.4-beta)|2019-01-03|PATCH: Fix #13.|
|v.10.2.3-beta|UNPUBLISHED|PATCH: small rework of the Kanban board Draw/PDF, introducing Unifont.|
|[v.10.2.2-beta](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.2.2-beta)|2019-01-02|PATCH: add the original Code of Conduct.|
|[v.10.2.1-beta](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.2.1-beta)|2018-12-18|PATCH: update the layout of the Kanban board.|
|[v.10.2.0-beta](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.2.0-beta)|2018-11-14|MINOR: add lead time stacked bar chart.|
|[v.10.1.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.1.1)|2018-11-10|PATCH: Rework Activities samples to have more dynamic sample data.|
|[v.10.1.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.1.0)|2018-10-20|MINOR: improve A3 board with WIP placeholder and Lead Time highlight.|
|[v.10.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.10.0.0)|2018-07-10|MAJOR: add Contributor Covenant Code of Conduct for possible contributors.|
|[v. 9.5.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.5.0)|2018-07-09|MINOR: improve Deadline column highlight showing all expired deadlines with respect to current date.|
|[v. 9.4.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.4.1)|2018-07-09|PATCH: unlock all previously locked sheets (easier to manage all updates and versioning...)|
|[v. 9.4.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.4.0)|2018-07-09|MINOR: add "Labels" column to follow ActionableAgile™ Analitycs tool DEMO source data, so providing more filtering opportunities.|
|[v. 9.3.2](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.3.2)|2018-06-26 |PATCH: blocks top rows for Activities, Metrics and Data sheets. PATCH: blocks modifications on all sheets (except Activities) with empty password, to simply highlight the fact that Activities should be the only read/write sheet. Feel free to unlock the sheets if you prefer.|
|[v. 9.3.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.3.0)|2018-06-12 |Solve issue #10. Add daily WIP and backlog run chart.|
|[v. 9.2.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.2.1)|2018-06-12 |Solve issue #9. Rename sheets with single word names.|
|[v. 9.2.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.2.0)|2018-06-01 |Add Impact and Likelihood metrics as described in *Kanban Maturity Model* book.|
|[v. 9.0.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.0.1)|2018-05-31 |Add percentile colouring for Lead Times column showing which reference percentile has been passed.|
|[v. 9.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%209.0.0)|2018-05-25 |Solve bug #5. Add "Effort" evaluation for single activity. Reworked "LT Data" sheet, "Flow Efficiency" sheet deleted. "Distribution" sheet added.|
|[v. 8.0.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%208.0.1)|2018-05-24 |Solve bug #4. Rename columns to better fit KMM book.|
|[v. 8.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%208.0.0)|2018-05-21 |Solve bugs #2 and #3. Plus add Links column.|
|[v. 7.2.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%207.2.1)|2018-05-20 | Bug #1 solved in the CFD. Now the column "Date" of the CFD Data starts from the min - 1 day.|
|[v. 7.2.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%207.2.0)|2018-05-11 | Add “Age” to scatterplot to represent deleted or WIP activities current LT. Add “mLT” to scatterplot.|
|[v. 7.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.%207.0.0)|2018-05-09 |Moving back basic statistics to "LT Data" folder in order to keep better compatibility with ActionableAgile™ Analitycs tool.|
|v. 6.0.0 |UNPUBLISHED|Moving basic statistics to "Activities" folder making easier filtering scatterplot by CoS (or whatever).|
|v. 5.0.0 |UNPUBLISHED|English translation.|
|v. 4.1.0 |  PRIVATO  |Grafico CFD fatto da cumulativo ("Dati CFD"). IN CORSO: aggiunta dati età in "Backlog".|
|v. 4.0.0 |  PRIVATO  |Dati CFD da min(*) altrimenti i conti non tornano… Ricalcolo medie Little.|
|[v.3.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.3.0.0)|2017-08-05 |Rinominata "Opzioni" in "Backlog" per compatibilità col formato di ActionableAgile™ Analitycs.|
|[v.2.1.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.2.1.0)|2017-08-05||
|[v.2.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.2.0.0)|2017-08-05 |Dati CFD da min("Fatto") invece che da min(*).|
|v. 1.4.1 |  PRIVATO  |Rimosso il vincolo di inizio delle ascisse.|
|v. 1.4.0 |  PRIVATO  |Massimo dell’ascissa dei grafici a massimo "Fatto", non più assoluto.|
|v. 1.3.2 |  PRIVATO  |Arrotondamento (giorno) intero percentili e media.|
|v. 1.3.1 |  PRIVATO  |Correzione calcolo throughput.|
|v. 1.3.0 |  PRIVATO  |Formattazione automatica per attività chiuse in ritardo.|
|v. 1.2.0 |  PRIVATO  |Formattazione automatica per Scadenza.|
|v. 1.1.0 |  PRIVATO  |CoS filtrate per classi standard. Pagina dati efficienza (Flow Efficiency).|
|[v.1.0.0](https://bitbucket.org/marcobresciani/aamfp/commits/tag/v.1.0.0)|2017-06-10 |Moved computed data to "LT Data" sheet. Renamed "Work Items" sheet as "Tasks". Splitting LT and Age columns. Added small Age chart.|
| v0.0.2  |UNPUBLISHED|Added this History page.|
|[Excel v.0.0.1](https://bitbucket.org/marcobresciani/aamfp/commits/tag/Excel%20v.0.0.1)|2017-06-10|First Microsoft Excel version.|
| v0.0.1  |2017-06-05 |First version.|
