<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');
  if ( !class_exists('XF') )
  die('Root class is not loaded, yet!');

/**
* XFAuth takes care of user authentication
* @package lbbackend
*/
class XFAuth {

  //public function __construct(){}
  //public function __destruct(){}

  /**
  * verify authentication credentials
  * @param string $user userid or username
  * @param string $pass password hash
  * @return array
  * @since 1.0.0
  */
  public static function check($user,$pass){
  $o = array('valid_user'=>false,'valid_password'=>false,'active'=>false,
  'id'=>0,'username'=>'','group'=>0,'password'=>'','login_fail'=>0);
    if ( is_numeric($user) ){ // allow to query numerical user id and string user names
    $q = 'u_id = :id';
    $t = 'int';
    }
    else{
    $q = 'u_name = :id';
    $t = 'str';
    }
  $schk = XF::sql_query("SELECT u_id,u_active,u_uuid,u_name,u_password,u_mail,u_group,u_login_fail,u_login_count
  FROM ".XF::tbl('user')." WHERE ".$q,
  array('id'=>array($user,$t)),__METHOD__,__LINE__);
  $data = $schk->fetchObject();
  $schk->closeCursor();
    if ( is_object($data) ){
    $o['valid_user'] = true;
    $o['password'] = $data->u_password;
    $o['active'] = (bool)$data->u_active;
    $o['id'] = intval($data->u_id);
    $o['username'] = strval($data->u_name);
    $o['group'] = intval($data->u_group);
    $o['login_fail'] = intval($data->u_login_fail);
    $o['login_count'] = intval($data->u_login_count);
    $o['autologin_validator'] = substr(hash('sha1', substr(str_replace('-','',$data->u_uuid),0,16) . $data->u_mail . (int)$data->u_group ),16,16);
      if ( self::validate_password($data->u_password,$pass) )
      $o['valid_password'] = true;
    }
  return $o;
  }

  /**
  * validates the password
  * server hash r1: salt(0-9{15}).hash(a-f0-9{64})
  * server hash r2: 02_salt(a-zA-Z0-9{12}).hash(a-f0-9{64})
  * client hash r1: 01_hash(a-f0-9{40})
  * @param string $a password from server, usually salted
  * @param string $b password from client, usually hashed
  * @return boolean
  * @since 1.0.0
  */
  public static function validate_password($a,$b){
  $ra = ( substr($a,2,1) === '_' ) ? intval(substr($a,0,2)) : 1;
  $rb = intval(substr($b,0,2));
  $b = substr($b,3);
    if ( !in_array($ra,array(1,2),true) || !in_array($rb,array(1),true) )
    return false;
    if ( $ra === 1 && !preg_match('/^[0-9]{15}\.[a-f0-9]{32,64}$/Du',$a) )
    return false;
    if ( $ra === 2 && preg_match('/^02_[a-zA-Z0-9]{12}\.[a-f0-9]{64}$/Du',$a) )
    $a = substr($a,3);
    else
    return false;
    if ( $ra === 1 && strlen($b) !== 40 )
    return false;
  $c = explode('.',$a);
  $b = XF::advhash($b.$c[0],false);
  return ( strcmp($c[1],$b) === 0 ) ? true : false;
  }

  /**
  * validate the current user session
  * @return mixed
  * @since 1.0.0
  */
  // TODO: [idle] vaildate_session() probably regenerate session-id (session_regenerate_id()) after x minutes to make attacks more difficult?
  public static function validate_session(){
  // output: false when session is expired otherwise array
  // status can be 'clear', 'tainted' or 'expired' - a reason is given.
    if ( !isset($_SESSION['xf_authentication']) )
    return false;
  $o = array('user_id'=>intval($_SESSION['xf_authentication']['id']),'status'=>'clear','reason'=>'');
  $u = XF::get_user($o['user_id']);
    if ( !$u || $_SESSION['xf_authentication']['status'] === 'expired' )
    return false;
    if ( $_SESSION['xf_authentication']['status'] === 'tainted' ){
      if ( XF::get_cfg('auth_use_reauth') )
      $o['reason'] = 'auth_fail_taint';
      else
      return false;
    }
    if ( intval($_SESSION['xf_authentication']['time']+XF::get_cfg('auth_max_lifetime')) < XF::vault_query('uts') )
    $o['reason'] = 'auth_fail_lifetime_exceeded';
    if ( (int)$_SESSION['xf_authentication']['token'] !== (int)$u['u_login_token'] )
    $o['reason'] = 'auth_fail_login_token_invalid';
    if ( XF::get_cfg('auth_bind_agent') && $_SESSION['xf_authentication']['client_hash'] !== XF::vault_query('client_hash') )
    $o['reason'] = 'auth_fail_agent_changed';
    if ( !$u['u_login_liberal'] ){
      if ( XF::get_cfg('auth_bind_ip') && $_SESSION['xf_authentication']['ip'] !== hash('sha1',XF::vault_query('client_ip')) )
      $o['reason'] = 'auth_fail_ip_changed';
    }
    if ( !empty($o['reason']) ) // authenticated session has been 'tainted'
    $_SESSION['xf_authentication']['status'] = $o['status'] = 'tainted';
    if ( XF::DEBUG )
    XFDebug::trace(__METHOD__,XF::arr2str($o));
    if ( $o['status'] !== 'clear' )
    XF::logger('info','msg','authentication_check_fail','reason',$o['reason'],'userid',(int)$_SESSION['xf_authentication']['id']);
  return $o;
  }

}
?>