<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009,2010 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_post_rate extends XFAction {
const USE_TAN = true;
/**
* @var integer base value of a rate (default is 2)
*/
const VOTE_BASE = 2;
/**
* @var integer maximum value of a rate including all bonuses (default is 10) - bonus currently unused!
*/
const VOTE_MAX = 10;
/**
* @var integer how many days does an user need to be registered before allowed to rate? (default is 7)
*/
const REQ_REGTIME_DAYS = 7;
/**
* @var integer how many posts does an user need to have before allowed to rate? (default is 10)
*/
const REQ_POST_COUNT = 10;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','post');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * fetch vars from asynchronous request
  * @param array $input input stream
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $id = XF::sanitize_var(XF::ifset($input,'post',0),'int');
  $rating = XF::sanitize_var(XF::ifset($input,'rate','+'),'str');
  $this->gpc = array('id'=>$id,'rate'=>$rating);
  return true;
  }

  /**
  * rate a posting
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
    try {
    $user = XF::get_user();
      if ( (int)$user['u_time_registration']+intval(self::REQ_REGTIME_DAYS*86400) > XF::vault_query('uts') ){
      $this->error = '{:rate_disallowed_by_short_membership}';
      return false;
      }
      if ( (int)$user['u_post_count'] < self::REQ_POST_COUNT ){
      $this->error = '{:rate_disallowed_by_being_too_quiet}';
      return false;
      }
    unset($user);
    $schk = XF::sql_query("SELECT COUNT(pr_p_id) AS has_rated FROM ".XF::tbl('post_rating')."
    WHERE pr_p_id = :postid AND pr_u_id = :userid",
    array('postid'=>array($this->gpc['id'],'int'),
    'userid'=>array(XF::vault_query('current_user_id'),'int')),__METHOD__,__LINE__);
    $check = $schk->fetchObject();
    $schk->closeCursor();
    $spos = XF::sql_query("SELECT p_topic_id,p_u_id FROM ".XF::tbl('post_meta')." WHERE p_id = :postid",
    array('postid'=>array($this->gpc['id'],'int')),__METHOD__,__LINE__);
    $postdata = $spos->fetchObject();
    $spos->closeCursor();
      if ( !is_object($postdata) ){
      $this->error = '{:no_valid_id}';
      return false;
      }
      else{
        if ( is_object($check) && (int)$check->has_rated > 0 )
        $this->error = '{:you_have_already_rated}';
        if ( (int)$postdata->p_u_id === XF::vault_query('current_user_id') && empty($this->error) )
        $this->error = '{:you_cannot_rate_yourself}';
      $postdata->p_topic_id = intval($postdata->p_topic_id);
      }

      if ( empty($this->error) ){
        if ( !XF::sql_transaction('begin',array('post_rating'=>'w','post_meta'=>'w')) )
        throw new XFE('unable to begin database transaction');
      $op = ( $this->gpc['rate'] === '+' ) ? '+' : '-';
      $score = intval(self::VOTE_BASE/*+$user['u_rating_bonus']*/);
        if ( $score > self::VOTE_MAX )
        $score = self::VOTE_MAX;
      $i = XF::sql_query("INSERT INTO ".XF::tbl('post_rating')." (pr_p_id,pr_u_id) VALUES (:postid,:userid)",
      array('postid'=>array($this->gpc['id'],'int'),
      'userid'=>array(XF::vault_query('current_user_id'),'int')),__METHOD__,__LINE__);
        if ( !$i )
        throw new XFE('could not insert rating for posting "'.$this->gpc['id'].'"');
      $u = XF::sql_query("UPDATE ".XF::tbl('post_meta')." SET p_rating = p_rating$op:rating WHERE p_id = :postid",
      array('postid'=>array($this->gpc['id'],'int'),
      'rating'=>array($score,'int')),__METHOD__,__LINE__);
      XF::logger(':'.$u,'postid',$this->gpc['id'],'rate',$op);
      XF::sql_transaction('commit');
      $cache = XFCache::topic($postdata->p_topic_id);
      XFCache::topic_delta($cache,'change_rate',array('id'=>$this->gpc['id'],'rate_value'=>$score,'rate'=>$this->gpc['rate']));
      XFCache::put('topic',$postdata->p_topic_id,$cache);
      XF::tpl_use_cache_pool($this->gpc['id'],'begin');
        if ( XF::$tpl->is_cached('post.tpl',$this->gpc['id']) )
        XF::$tpl->clear_cache('post.tpl',$this->gpc['id']);
      XF::tpl_use_cache_pool(0,'reset');
      require_once(XF::vault_query('root_path').'/class.parser.php');
      XF::user_calculations((int)$check->p_u_id);
      $this->success = true;
      }

    } catch ( XFE $E ){ $E->handle(); if ( $E->check_abort() ) return false; }
  return true;
  }

}

  function xfaf_post_rate($input){
  $a = new XFAction_post_rate();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success('','{:successfully_rate_posting}');
    else
    return xfaf_failure($a->get_error());
  }

?>