<?php
/* LARUS BOARD ========================================================
 * Encoded in UTF-8 (micro symbol: µ)
 * Copyright © 2008,2009 by "The Larus Board Team"
 * This file is part of "Larus Board".
 *
 * "Larus Board" is free software: you can redistribute it and/or modify
 * it under the terms of the modified BSD license.
 *
 * "Larus Board" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * You should have received a copy of the modified BSD License
 * along with this package. If not, see
 * <http://download.savannah.gnu.org/releases/larusboard/COPYING.BSD>.
 */
  if ( !defined('__XF_INCLUDE') )
  die('File "'.basename(__FILE__).'" cannot be executed directly!');

/**
* @package lbfrontend
*/
class XFAction_search extends XFAction {
const USE_TAN = false;
/**
* @var integer limit search results to x items (default is 1000)
*/
const LIMIT_SEARCH = 1000;
protected $success = false;
protected $error = '';
protected $gpc = array();
protected $markgpc = array();
public $version = 0x01;
/**
* @var string hash of current search query
*/
public $hash = '';

  /**
  * @param string $a select handler
  * @param array $b input data for asynchronous request
  * @return mixed
  * @since 1.0.0
  */
  public function init($a,$b){
  XFUI::load_lang_res('','search');
  return $this->$a($b);
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function regular(){
  $stage = XF::sanitize_var(XF::ifset('get','stage','form'),'enum','o=form,o=by_tag,o=by_user,o=by_time,o=by_today,o=by_last_read,o=result');
  $noresult = XF::sanitize_var(XF::ifset('get','noresult',0),'booli');
  $clear = XF::sanitize_var(XF::ifset('get','clear',0),'booli');
  $this->gpc = array('stage'=>$stage,'noresult'=>$noresult,'clear'=>$clear);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('search'));
  unset($stage,$noresult,$clear);

    if ( $this->gpc['stage'] === 'by_tag' )
    return $this->search_by_tag();
    elseif ( $this->gpc['stage'] === 'by_user' )
    return $this->search_by_user();
    elseif ( $this->gpc['stage'] === 'by_time' )
    return $this->search_by_time();
    elseif ( $this->gpc['stage'] === 'by_today' )
    return $this->search_by_today();
    elseif ( $this->gpc['stage'] === 'by_last_read' && XF::vault_query('is_logged_in') )
    return $this->search_by_last_read();
    elseif ( $this->gpc['stage'] === 'result' )
    return $this->get_results();

    if ( $this->gpc['clear'] === 1 && isset($_SESSION['xf_search_hash']) ){
    XF::sql_query("DELETE FROM ".XF::tbl('search_result')." WHERE sr_hash = :hash",array('hash'=>array($_SESSION['xf_search_hash'],'int')),__METHOD__,__LINE__);
    unset($_SESSION['xf_search_hash'],$_SESSION['xf_search_result_restore_page']);
    }

  XFUI::ajax_init();
  XFUI::html_head('{:search}');
  XF::$tpl->assign('no_search_result',(bool)$this->gpc['noresult']);
  XF::$tpl->assign('post_prefix_listing',XFUI::get_post_prefix_list(true));
  XF::$tpl->assign('ipp_listing',array(5,10,20,50,100));
  XF::$tpl->assign('sort_listing',array('id'=>XFUI::i18n('id'),'author'=>XFUI::i18n('author'),'date'=>XFUI::i18n('date'),'rating'=>XFUI::i18n('rating'),'approve'=>XFUI::i18n('approvement')));
  XF::$tpl->assign('order_listing',array('asc'=>XFUI::i18n('ascending'),'desc'=>XFUI::i18n('descending')));
  XF::$tpl->display('form_search.tpl',crc32($this->gpc['noresult'].XF::vault_query('current_language')));
  XFUI::html_foot();
  /*$this->gpc = array(
  'f_time'=>'','f_query'=>'','f_query_tags'=>0,
  'f_query_subject'=>1,'f_query_message'=>1,'f_ipp'=>20,'f_sort'=>'id','f_order'=>'asc',
  'f_group_by_topic'=>1);
  self::execute();
  self::search_by_last_read();*/
  return true;
  }

  /**
  * run a preset search query: posts by tag
  * @return true
  * @since 1.0.0
  */
  public function search_by_tag(){
  $tag = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $this->gpc = array('tag'=>$tag);
  unset($tag);
    if ( $this->gpc['tag'] > 0 ){
    $this->gpc = array('by_tag'=>$this->gpc['tag'],'f_ipp'=>20,'f_sort'=>'date','f_order'=>'desc','f_group_by_topic'=>0);
    $this->execute();
    }
    if ( $this->success )
    XFUI::html_redirect(-1,XF::link('search',array('stage'=>'result','hash'=>$this->hash,'start'=>0,'pp'=>20)));
    else
    XFUI::html_redirect(-1,XF::link('search',array('noresult'=>1)));
  return true;
  }

  /**
  * run a preset search query: posts by user
  * @return true
  * @since 1.0.0
  */
  public function search_by_user(){
  $user = XF::sanitize_var(XF::ifset('get','id',0),'int');
  $this->gpc = array('user'=>$user);
  unset($user);
    if ( $this->gpc['user'] > 0 ){
    $this->gpc = array('by_user'=>$this->gpc['user'],'f_ipp'=>20,'f_sort'=>'date','f_order'=>'desc','f_group_by_topic'=>0);
    $this->execute();
    }
    if ( $this->success )
    XFUI::html_redirect(-1,XF::link('search',array('stage'=>'result','hash'=>$this->hash,'start'=>0,'pp'=>20)));
    else
    XFUI::html_redirect(-1,XF::link('search',array('noresult'=>1)));
  return true;
  }

  /**
  * run a preset search query: posts by time
  * @return true
  * @since 1.0.0
  */
  public function search_by_time(){
  $time = XF::sanitize_var(XF::ifset('get','id',''),'mdate');
  $this->gpc = array('time'=>$time);
  unset($time);
    if ( $this->gpc['time'] ){
    $this->gpc = array('by_time'=>$this->gpc['time'],'f_ipp'=>20,'f_sort'=>'date','f_order'=>'desc','f_group_by_topic'=>1);
    $this->execute();
    }
    if ( $this->success )
    XFUI::html_redirect(-1,XF::link('search',array('stage'=>'result','hash'=>$this->hash,'start'=>0,'pp'=>20)));
    else
    XFUI::html_redirect(-1,XF::link('search',array('noresult'=>1)));
  return true;
  }

  /**
  * run a preset search query: posts by today
  * @return true
  * @since 1.0.0
  */
  public function search_by_today(){
  $this->gpc = array('by_today'=>1,'f_ipp'=>20,'f_sort'=>'date','f_order'=>'desc','f_group_by_topic'=>1);
  $this->execute();
    if ( $this->success )
    XFUI::html_redirect(-1,XF::link('search',array('stage'=>'result','hash'=>$this->hash,'start'=>0,'pp'=>20)));
    else
    XFUI::html_redirect(-1,XF::link('search',array('noresult'=>1)));
  return true;
  }

  /**
  * run a preset search query: posts by last read timestamp
  * @return true
  * @since 1.0.0
  */
  public function search_by_last_read(){
  $this->gpc = array('by_last_read'=>1,'f_ipp'=>20,'f_sort'=>'date','f_order'=>'desc','f_group_by_topic'=>1);
  $this->execute();
    if ( $this->success )
    XFUI::html_redirect(-1,XF::link('search',array('stage'=>'result','hash'=>$this->hash,'start'=>0,'pp'=>20)));
    else
    XFUI::html_redirect(-1,XF::link('overview'));
  return true;
  }

  /**
  * @return true
  * @since 1.0.0
  */
  protected function ajax($input){
  $sbt = XF::sanitize_var(XF::ifset($input,'by_tag',0),'int');
  $sbu = XF::sanitize_var(XF::ifset($input,'by_user',0),'int');
  $sbi = XF::sanitize_var(XF::ifset($input,'by_time',''),'str','okifempty');
  $sbo = XF::sanitize_var(XF::ifset($input,'by_today',0),'booli');
  $sbl = XF::sanitize_var(XF::ifset($input,'by_last_read',0),'booli');
  $spf = XF::sanitize_var(XF::ifset($input,'f_prefix',0),'int');
  $sau = XF::sanitize_var(XF::ifset($input,'f_author',''),'str','okifempty');
  $sti = XF::sanitize_var(XF::ifset($input,'f_time',''),'str','okifempty');
  $squ = XF::sanitize_var(XF::ifset($input,'f_query',''),'str','okifempty');
  $sqt = XF::sanitize_var(XF::ifset($input,'f_query_tags',0),'booli');
  $sqs = XF::sanitize_var(XF::ifset($input,'f_query_subject',0),'booli');
  $sqm = XF::sanitize_var(XF::ifset($input,'f_query_message',0),'booli');
  $sfi = XF::sanitize_var(XF::ifset($input,'f_ipp',20),'int','range=5-100');
  $sfs = XF::sanitize_var(XF::ifset($input,'f_sort','date'),'enum','o=id,o=author,o=date,o=rating,o=approve');
  $sfo = XF::sanitize_var(XF::ifset($input,'f_order','desc'),'enum','o=asc,o=desc');
  $sgt = XF::sanitize_var(XF::ifset($input,'f_group_by_topic',0),'booli');
  $this->gpc = array('by_tag'=>$sbt,'by_user'=>$sbu,'by_time'=>$sbi,'by_today'=>$sbo,'by_last_read'=>$sbl,
  'f_prefix'=>$spf,'f_author'=>$sau,'f_time'=>$sti,'f_query'=>$squ,'f_query_tags'=>$sqt,
  'f_query_subject'=>$sqs,'f_query_message'=>$sqm,'f_ipp'=>$sfi,'f_sort'=>$sfs,'f_order'=>$sfo,
  'f_group_by_topic'=>$sgt);
  $this->markgpc = array('f_author','f_time','f_query');
  return true;
  }

  /**
  * perform a search in database
  * @return boolean
  * @since 1.0.0
  */
  public function execute(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  $like = ( __XF_SQL_ENGINE === 'pgsql' ) ? 'ILIKE' : 'LIKE';
  $perform_search = true;
  $data = array();
    if ( isset($this->gpc['by_tag']) && $this->gpc['by_tag'] !== 0 )
    $process = array('by_tag','format');
    elseif ( isset($this->gpc['by_user']) && $this->gpc['by_user'] !== 0 )
    $process = array('by_user','format');
    elseif ( isset($this->gpc['by_time']) && $this->gpc['by_time'] !== '' )
    $process = array('by_time','format');
    elseif ( isset($this->gpc['by_today']) && $this->gpc['by_today'] === 1 )
    $process = array('by_today','format');
    elseif ( isset($this->gpc['by_last_read']) && $this->gpc['by_last_read'] === 1 )
    $process = array('by_last_read','format');
    else
    $process = array('prefix','author','time','query','format');
  XF::statistic('search_query');

    do {
      switch ( array_shift($process) ){
      case 'prefix':
        if ( !empty($this->gpc['f_prefix']) )
        $data['prefix'] = intval($this->gpc['f_prefix']);
      break;
      case 'author':
        if ( empty($this->gpc['f_author']) ) continue;
      $op = explode(' ',$this->gpc['f_author']);
        foreach ( $op as $v ){
        $v = trim($v);
          if ( is_numeric($v) )
          $data['author'][] = intval($v);
          elseif ( strlen($v) >= 2 ){
          $susr = XF::sql_query("SELECT u_id FROM ".XF::tbl('user')."
          WHERE u_name $like ".str_replace('*','%',XF::$sql->quote($v)),'',__METHOD__,__LINE__);
            while ( $r = $susr->fetchObject() )
            $data['author'][] = intval($r->u_id);
          $susr->closeCursor();
          }
        }
        if ( isset($data['author']) && sizeof($data['author']) > 0 )
        $data['author'] = array_unique($data['author']);
      break;
      case 'time':
        if ( strlen($this->gpc['f_time']) < 10 ) continue;
      $ts0 = false;
      $ts1 = false;
      preg_match_all('/(\d+)([\.\-]{1})(\d+)([\.\-]{1})(\d+)/u',$this->gpc['f_time'],$r,PREG_SET_ORDER);
        if ( sizeof($r) > 0 ){
          foreach ( $r as $k=>$v ){
          $v = self::fdate($v,$k);
          $k = 'ts'.$k;
            if ( $v !== false )
            ${$k} = intval($v);
          }
        }
        if ( sizeof($r) === 1 && $ts0 !== false )
        $ts1 = self::fdate($r[0],1);
        if ( $ts1 < $ts0 )
        $ts1 = self::fdate($r[0],1);
        if ( $ts0 !== false )
        $data['date'][0] = $ts0;
        if ( $ts1 !== false )
        $data['date'][1] = $ts1;
      break;
      case 'query':
        if ( strlen($this->gpc['f_query']) < 2 ) continue;
      $op = explode(' ',$this->gpc['f_query']);
        foreach ( $op as $v ){
        $v = trim(preg_replace('/[\x00-\x1f_%\'\-\*]+/u','',$v));
          if ( strlen($v) > 0 )
          $data['query']['str'][] = $v;
        }
        if ( is_array($data['query']['str']) && sizeof($data['query']['str']) > 0 )
        $data['query']['str'] = array_unique($data['query']['str']);
      $data['query']['tg'] = array();
      $data['query']['op']['tags'] = (bool)$this->gpc['f_query_tags'];
        if ( $data['query']['op']['tags'] ){
        XFParser::tag_query($op);
          foreach ( $op as $v ){
          $k = array_search($v,XF::$tags);
            if ( $k > 0 )
            $data['query']['tg'][] = $k;
          }
        }
      $data['query']['op']['subject'] = (bool)$this->gpc['f_query_subject'];
      $data['query']['op']['message'] = (bool)$this->gpc['f_query_message'];
      break;
      case 'by_tag':
      $data['query']['op']['tags'] = true;
      $data['query']['tg'][] = (int)$this->gpc['by_tag'];
      break;
      case 'by_user':
      $data['author'][] = (int)$this->gpc['by_user'];
      break;
      case 'by_time':
      $k = explode('.',$this->gpc['by_time']);
      $v = date('t',gmmktime(0,0,0,$k[1],1,$k[0]));
      $data['date'][0] = gmmktime(0,0,0,$k[1],1,$k[0]);
      $data['date'][1] = gmmktime(23,59,59,$k[1],$v,$k[0]);
      break;
      case 'by_today':
      $data['date'][0] = gmmktime(0,0,0,gmdate('m'),gmdate('d'),gmdate('Y'));
      $data['date'][1] = gmmktime(23,59,59,gmdate('m'),gmdate('d'),gmdate('Y'));
      break;
      case 'by_last_read':
      $user = XF::get_user();
      $data['date'][0] = $user['u_time_last_read'];
      $data['date'][1] = XF::vault_query('uts');
      break;
      case 'format':
      $a1 = array('id'=>'p_id','author'=>'p_u_id','date'=>'p_time','rating'=>'p_rating','approve'=>'p_approved');
      $a2 = array('asc'=>'ASC','desc'=>'DESC');
      $data['format']['per_page'] = intval($this->gpc['f_ipp']);
      $data['format']['sort'] = strtr($this->gpc['f_sort'],$a1);
      $data['format']['order'] = strtr($this->gpc['f_order'],$a2);
      $data['format']['group_by_topic'] = (bool)$this->gpc['f_group_by_topic'];
      break;
      default: break;
      }
    } while ( sizeof($process) > 0 );
  unset($a1,$a2,$k,$v,$r,$ts0,$ts1,$op);
  // well, data has been processed. now query the database...
  //D($data);
  $this->hash = crc32(print_r($data,true));
  $process = array();
  $schk = XF::sql_query("SELECT COUNT(sr_p_id) AS sr_count FROM ".XF::tbl('search_result')." WHERE sr_hash = :hash",
  array('hash'=>array($this->hash,'int')),__METHOD__,__LINE__);
  $r = $schk->fetchObject();
  $schk->closeCursor();
    if ( (int)$r->sr_count > 0 ){ // results already in database, forward immediately ;)
    XF::statistic('search_cached');
    $this->success = true;
      if ( XF::DEBUG )
      XFDebug::trace(__METHOD__,'redirect to cached results for hash "'.$this->hash.'"');
    return true;
    }

    if ( isset($data['query']['op']['message']) && $data['query']['op']['message'] ){
      if ( __XF_SQL_ENGINE === 'mysql' )
      $fts = "MATCH(pd_text) AGAINST (".XF::$sql->quote(implode(' ',$data['query']['str']))." IN BOOLEAN MODE)";
      elseif ( __XF_SQL_ENGINE === 'pgsql' )
      $fts = "pd_text $like '%".implode('%',$data['query']['str'])."%'";
    $smes = XF::sql_query("SELECT p_id FROM ".XF::tbl('post_data')."
    LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_pd_id = pd_id
    WHERE pd_is_last = true AND $fts LIMIT ".self::LIMIT_SEARCH." OFFSET 0",'',__METHOD__,__LINE__);
      while ( $r = $smes->fetchObject() )
      $process[] = intval($r->p_id);
    $smes->closeCursor();
    }
    if ( isset($data['query']['op']['tags']) && sizeof($data['query']['tg']) > 0 ){
    $stag = XF::sql_query("SELECT DISTINCT(td_p_id)
    FROM ".XF::tbl('tag_data')."
    WHERE td_t_id IN (".implode(',',$data['query']['tg']).") LIMIT ".self::LIMIT_SEARCH." OFFSET 0",'',__METHOD__,__LINE__);
      while ( $r = $stag->fetchObject() )
      $process[] = intval($r->td_p_id);
    $stag->closeCursor();
    }

  $process = array_unique($process);
  $q = array();
    if ( isset($data['format']) && sizeof($data) === 1 )
    $perform_search = false;
    if ( sizeof($process) > 0 )
    $q[] = 'p_id IN ('.implode(',',$process).')';
    if ( isset($data['prefix']) )
    $q[] = "p_pp_id = ".$data['prefix'];
    if ( isset($data['author']) )
    $q[] = 'p_u_id IN ('.implode(',',$data['author']).')';
    if ( isset($data['date']) && sizeof($data['date']) === 2 && $data['date'][0] !== false && $data['date'][1] !== false )
    $q[] = "p_time BETWEEN ".$data['date'][0]." AND ".$data['date'][1];
    if ( isset($data['query']['op']['subject']) && $data['query']['op']['subject'] )
    $q[] = "p_subject $like '%".implode('%',$data['query']['str'])."%'";
    if ( sizeof($q) === 0 )
    $q[] = 'true';
    if ( $data['format']['group_by_topic'] ){
    $groupby = 'GROUP BY p_topic_id';
    $select = 'MIN(p_id) AS p_id,MIN('.$data['format']['sort'].') AS '.$data['format']['sort'].',p_topic_id';
    }
    else{
    $groupby = '';
    $select = 'p_id';
    }
    if ( !$perform_search )
    return false;
  $q = 'SELECT '.$select.' FROM '.XF::tbl('post_meta').'
  WHERE ( '.implode(' OR ',$q).' ) AND p_approved = \'1\'
  '.$groupby.'
  ORDER BY '.$data['format']['sort'].' '.$data['format']['order'].'
  LIMIT '.self::LIMIT_SEARCH.' OFFSET 0';
  $spst = XF::sql_query($q,'',__METHOD__,__LINE__);
    while ( $r = $spst->fetchObject() )
    $process[] = intval($r->p_id);
  $spst->closeCursor();
  $process = array_unique($process);
  //D($process,$q); $process = array();
  // put results to temporary table in database...
    if ( sizeof($process) > 0 ){
    $time = XF::vault_query('uts');
    $sres = XF::$sql->prepare("INSERT INTO ".XF::tbl('search_result')." (sr_time,sr_hash,sr_p_id) VALUES (:time,:hash,:postid)");
    $sres->bindParam(':time',$time,PDO::PARAM_INT);
    $sres->bindParam(':hash',$this->hash,PDO::PARAM_INT);
      foreach ( $process as $v ){ // do it ourself, instead of sql_query as this is considerably faster ;)
      $sres->bindValue(':postid',$v,PDO::PARAM_INT);
      $sres->execute();
      }
    $sres->closeCursor();
    $this->success = true;
      if ( XF::DEBUG )
      XFDebug::trace(__METHOD__,$this->hash);
    }
  return true;
  }

  /**
  * fetch results from database
  * @return true
  * @since 1.0.0
  */
  // TODO: [idle] get_results() select SQL_CALC_FOUND_ROWS * from thetable -> any counterpart in postgres?
  public function get_results(){
  require_once(XF::vault_query('root_path').'/class.parser.php');
  $hash = XF::sanitize_var(XF::ifset('get','hash',0),'int');
  $start = XF::sanitize_var(XF::ifset('get','start',0),'int');
  $perpage = XF::sanitize_var(XF::ifset('get','pp',20),'int');
  $this->gpc = array('hash'=>$hash,'start'=>$start,'perpage'=>$perpage);
    if ( !XF::validate_gpc_data($this->gpc) )
    XFUI::html_redirect(-1,XF::link('search'));
  unset($hash,$start,$perpage);

    if ( session_id() )
    $_SESSION['xf_search_hash'] = $this->gpc['hash'];
    if ( XF::ifset('get','start',false) === false && isset($_SESSION['xf_search_result_restore_page']) )
    $this->gpc['start'] = intval($_SESSION['xf_search_result_restore_page']);
    elseif ( session_id() && XF::ifset('get','start',false) !== false )
    $_SESSION['xf_search_result_restore_page'] = $this->gpc['start'];

  XFUI::html_head('{:search}');
  $cachehandler = crc32(print_r($this->gpc,true));
  XF::tpl_use_cache_pool($cachehandler,'begin');
  //XF::$tpl->clear_cache('search_results.tpl',$cachehandler);

    if ( !XF::$tpl->is_cached('search_results.tpl',$cachehandler) ){
    $snum = XF::sql_query('SELECT COUNT(sr_p_id) AS sr_count FROM '.XF::tbl('search_result').'
    WHERE sr_hash = :hash',array('hash'=>array($this->gpc['hash'],'int')),__METHOD__,__LINE__);
    $num = $snum->fetchObject();
    $pagecount = ceil($num->sr_count/$this->gpc['perpage']);
    $snum->closeCursor();

    $sres = XF::sql_query("SELECT p_id,p_is_topic,p_topic_id,p_u_id,p_time,p_rating,p_approved,p_pp_id,p_subject FROM ".XF::tbl('search_result')."
    LEFT JOIN ".XF::tbl('post_meta')." ON ".XF::tbl('post_meta').".p_id = ".XF::tbl('search_result').".sr_p_id
    WHERE sr_hash = :hash ORDER BY p_weight DESC LIMIT :pp OFFSET :start",
    array('hash'=>array($this->gpc['hash'],'int'),
    'start'=>array($this->gpc['start'],'int'),
    'pp'=>array($this->gpc['perpage'],'int')),__METHOD__,__LINE__);
      if ( $sres->rowCount() === 0 )
      XFUI::html_redirect(-1,XF::link('search',array('noresult'=>1)));
    $pp = XFUI::get_post_prefix_list();
    $group = XF::get_group();
    $access_cache = array();
    $blacklist_count = 0;
    $posts = array();
      while ( $r = $sres->fetchObject() ){
      $r->p_id = intval($r->p_id);
      $r->p_is_topic = (bool)$r->p_is_topic;
      $r->p_topic_id = intval($r->p_topic_id);
      $r->p_u_id = intval($r->p_u_id);
      $blacklist = ( isset($_SESSION['xf_blacklist']) && in_array($r->p_u_id,$_SESSION['xf_blacklist'],true) ) ? true : false;
        if ( $blacklist ){
        $blacklist_count++;
        continue;
        }
      $useid = ( $r->p_is_topic ) ? $r->p_id : intval($r->p_topic_id);
      $cache = XFCache::topic($useid);
      $access = ( isset($access_cache[$r->p_topic_id]) ) ? $access_cache[$r->p_topic_id] : XFUI::topic_access($cache,$pp);
      $lastpost = XFParser::lastpost($cache,$group['g_read_unapproved']);
      XF::get_user(array($r->p_u_id,$cache['user'][$lastpost]));
      $user_main = XF::get_user($r->p_u_id);
      $user_last = XF::get_user($cache['user'][$lastpost]);
        if ( $r->p_is_topic )
        $rating = ( sizeof($cache['rating']) > 0 ) ? XFParser::limit_rating(array_sum($cache['rating'])) : 0;
        else
        $rating = ( (double)$r->p_rating !== 0 ) ? XFParser::limit_rating((double)$r->p_rating) : 0;
      $subject = ( isset($pp[(int)$r->p_pp_id]) ) ? '['.$pp[(int)$r->p_pp_id]['pp_name'].'] '.$r->p_subject : $r->p_subject;
      $posts[$r->p_id] = array(
      'p_id'=>intval($r->p_id),
      'p_topic_id'=>intval($r->p_topic_id),
      'p_is_topic'=>$r->p_is_topic,
      'p_subject'=>$subject,
      'p_time'=>intval($r->p_time),
      'p_approved'=>(bool)$r->p_approved,
      'p_rating'=>$rating,
      'u_name'=>$user_main['u_name'],
      'reply_count'=>XFParser::get_reply_count($cache['tree'],'+'),
      'last_reply_id'=>$lastpost,
      'last_reply_user'=>$user_last['u_name'],
      'last_reply_time'=>$cache['time'][$lastpost],
      'access_allow'=>$access
      );
      $access_cache[$r->p_topic_id] = $access;
      }
    $sres->closeCursor();

    XF::$tpl->cache_lifetime = 1800;
    XF::$tpl->assign('posting_listing',$posts);
    XF::$tpl->assign('hits_count',(int)$num->sr_count);
    XF::$tpl->assign('blacklist_count',$blacklist_count);
    XF::$tpl->assign('hash',$this->gpc['hash']);
    XF::$tpl->assign('pages',$pagecount);
    XF::$tpl->assign('offset',$this->gpc['start']);
    XF::$tpl->assign('perpage',$this->gpc['perpage']);
    XF::$tpl->assign('list_start',($this->gpc['start']===0)?1:$this->gpc['start']);
    XF::$tpl->assign('list_end',($this->gpc['start']+$this->gpc['perpage'] > (int)$num->sr_count)?(int)$num->sr_count:$this->gpc['start']+$this->gpc['perpage']);
    }

  XF::$tpl->display('search_results.tpl',$cachehandler);
  XF::tpl_use_cache_pool(0,'reset');
  XFUI::html_foot();
  return true;
  }

  /**
  * format a timespan
  * @param string $a timestamp in format yyyy-mm-dd or dd.mm.yyyy
  * @param integer $b if '0', time is midnight otherwise one second before
  * @return mixed
  * @since 1.0.0
  */
  protected static function fdate($a,$b){
    if ( $b === 0 )
    $c = array(0,0,0); // makes start of a day
    else
    $c = array(23,59,59); // makes end of a day
    if ( $a[2] === '-' ){
      if ( checkdate($a[3],$a[5],$a[1]) )
      return gmmktime($c[0],$c[1],$c[2],$a[3],$a[5],$a[1]);
      else
      return false;
    }
    elseif ( $a[2] === '.' ){
      if ( checkdate($a[3],$a[1],$a[5]) )
      return gmmktime($c[0],$c[1],$c[2],$a[3],$a[1],$a[5]);
      else
      return false;
    }
  }

}

  function xfaf_search($input){
  $a = new XFAction_search();
  $a->init('ajax',$input);
    if ( !xfaf_process_data($a->get_GPC(),$a->get_mark_GPC()) )
    return false;
  $b = $a->get_GPC();
  $a->execute();
    if ( $a->get_success() )
    return xfaf_success(XF::link('search',array('stage'=>'result','hash'=>$a->hash,'start'=>0,'pp'=>$b['f_ipp']),false),'{:search_successful}');
    else
    return xfaf_failure('{:search_no_result}');
  }

?>