/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.natto.ExecSecurity;
import org.natto.Executor;
import org.natto.Infofiles;
import org.natto.StaticTools;

public class jobDescription {
    private String workDir = "";

    public jobDescription(String sharedDir) {
        this.workDir = sharedDir;
    }

    public String writeJobDescription(File file1, File file2, File zipFile, HashMap prgHash, String clineExtra, String toHost) {
        String myUniq = UUID.randomUUID().toString();
        String jobFileName = this.workDir + "/" + myUniq + ".jd";
        boolean submitOk = true;
        try {
            String diStr;
            String wcommandLine;
            PrintWriter writer = new PrintWriter(jobFileName, "UTF-8");
            String myId = Executor.getId();
            writer.println("clientid=" + myId);
            String f1Name = file1.getName();
            writer.println("binaryinputfilename=" + f1Name);
            writer.println("jobname=" + f1Name);
            String myExt = StaticTools.getFileExt(f1Name);
            if (myExt == null) {
                wcommandLine = f1Name.startsWith("INTERNAL") ? "workercommandline=" + f1Name : "workercommandline=./" + f1Name;
            } else {
                String myPrg = Infofiles.getPrgForExt(myExt, prgHash);
                wcommandLine = "workercommandline=" + myPrg + " " + f1Name;
            }
            writer.println(wcommandLine);
            if (!"".equals(clineExtra)) {
                writer.println("arguments=" + clineExtra);
            }
            ArrayList<String> dataInputAl = new ArrayList<String>();
            if (zipFile != null) {
                dataInputAl.add(zipFile.getName());
            }
            if (file2 != null) {
                dataInputAl.add(file2.getName());
            }
            if ((diStr = StaticTools.join(dataInputAl, ";")) != null) {
                writer.println("datainputfilename=" + diStr);
            }
            if (toHost != null && !"".equals(toHost)) {
                writer.println("targethost=" + toHost);
            }
            writer.close();
        }
        catch (Exception e) {
            submitOk = false;
        }
        ExecSecurity mySecurity = ExecSecurity.getInstance();
        if (mySecurity.securityOn()) {
            mySecurity.clearSignFile(jobFileName);
        }
        if (submitOk) {
            return "Task " + myUniq + " submitted.";
        }
        return "Sorry, submit failed.";
    }

    public String writeInternalCommand(String command, String param, String toHost) {
        String retMe = this.writeJobDescription(new File("INTERNAL:" + command), null, null, null, param, toHost);
        return retMe;
    }
}

