/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;

public class Task {
    private long startTime;
    private long finishTime;
    private int taskStatus;
    private String runfileName;
    private String execHost;
    private Thread jobProcess;
    private int exitCode;
    public static int IDLE = 0;
    public static int RUNNING = 1;
    public static int DONE = 2;
    public static int NOTIFIED = 3;

    public Task(String rfName, Thread myPr, String runsWhere) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        long secSinceEpoch = calendar.getTimeInMillis() / 1000L;
        this.runfileName = rfName;
        this.jobProcess = myPr;
        this.startTime = secSinceEpoch;
        this.taskStatus = RUNNING;
        this.execHost = runsWhere;
        Properties runProperties = new Properties();
        runProperties.put("starttime", Long.toString(this.startTime));
        runProperties.put("status", Integer.toString(this.taskStatus));
        runProperties.put("exechost", this.execHost);
        try {
            runProperties.store(new FileOutputStream(rfName), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Task(String rfName) {
        this.runfileName = rfName;
    }

    public void eraseCompletely() {
        String outFileName = this.runfileName.replace(".run", ".stdout");
        String errFileName = this.runfileName.replace(".run", ".stderr");
        String jdFileName = this.runfileName.replace(".run", ".jd");
        String signedFileName = this.runfileName.replace(".run", ".jd.asc");
        String[] allFileNames = new String[]{this.runfileName, outFileName, errFileName, jdFileName, signedFileName};
        for (int i = 0; i < allFileNames.length; ++i) {
            File file = new File(allFileNames[i]);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    public void finishTask(int exitCode) {
        long secSinceEpoch;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        this.finishTime = secSinceEpoch = calendar.getTimeInMillis() / 1000L;
        Properties runProperties = new Properties();
        try {
            runProperties.load(new FileInputStream(this.runfileName));
            runProperties.put("status", Integer.toString(DONE));
            runProperties.put("exitcode", Integer.toString(exitCode));
            runProperties.put("finishtime", Long.toString(this.finishTime));
            FileOutputStream fileOut = new FileOutputStream(this.runfileName);
            runProperties.store(new FileOutputStream(this.runfileName), null);
            fileOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getStatus() {
        Properties runProperties = new Properties();
        int retMe = IDLE;
        try {
            runProperties.load(new FileInputStream(this.runfileName));
            String strStatus = runProperties.getProperty("status");
            retMe = Integer.parseInt(strStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMe;
    }

    public void setStatus(int status) {
        this.taskStatus = status;
        Properties runProperties = new Properties();
        try {
            runProperties.load(new FileInputStream(this.runfileName));
            runProperties.put("status", Integer.toString(status));
            runProperties.store(new FileOutputStream(this.runfileName), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getExitCode() {
        Properties runProperties = new Properties();
        int retMe = -100;
        try {
            runProperties.load(new FileInputStream(this.runfileName));
            String strStatus = runProperties.getProperty("exitcode");
            retMe = Integer.parseInt(strStatus);
            runProperties.store(new FileOutputStream(this.runfileName), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retMe;
    }
}

