/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetAddress;
import org.natto.StaticTools;

public class Sysinfo {
    int cores = 1;
    int mhz = 1000;
    int memMeg = 256;
    String hostName = "unknown";

    public Sysinfo() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            this.regReadCpu();
            this.wmicGetMem();
        }
        if (osName.startsWith("Linux")) {
            this.procReadCpu();
            this.procReadMem();
        }
        if (osName.startsWith("Mac")) {
            this.sysctlReadCpuMem();
        }
        this.readHostName();
    }

    public int getCores() {
        return this.cores;
    }

    public int getMhz() {
        return this.mhz;
    }

    public int getMemMeg() {
        return this.memMeg;
    }

    public long getFreeDiskMeg() {
        String[] dfFigs;
        long freeMegs = 0L;
        String cmd = "df -m .";
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            cmd = "cmd /c dir /-C";
        }
        String dfOut = StaticTools.execGet(cmd, false);
        dfOut = dfOut.trim();
        String lastLine = "";
        int crPos = dfOut.lastIndexOf("\n");
        if (crPos > 0) {
            lastLine = dfOut.substring(crPos + 1, dfOut.length());
        }
        if ((dfFigs = lastLine.split("\\s+")).length > 3) {
            String freeStr = dfFigs[3];
            try {
                if (osName.startsWith("Windows")) {
                    long freeBytes = Long.parseLong(freeStr);
                    long freeKs = freeBytes / 1024L;
                    freeMegs = freeKs / 1024L;
                } else {
                    freeMegs = Long.parseLong(freeStr);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return freeMegs;
    }

    public String getHostName() {
        return this.hostName;
    }

    void readHostName() {
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            this.hostName = localMachine.getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void procReadCpu() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            int myCores = 0;
            while (line != null) {
                int afterCo;
                if (line.startsWith("processor")) {
                    ++myCores;
                }
                if (line.contains("cpu MHz") && (afterCo = line.indexOf(": ")) > 0) {
                    String mHzStr = line.substring(afterCo + 2, line.length());
                    float mFloat = Float.parseFloat(mHzStr);
                    this.mhz = (int)mFloat;
                }
                line = br.readLine();
            }
            br.close();
            this.cores = myCores;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void procReadMem() {
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/meminfo"));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                String[] strParts;
                if (line.contains("MemTotal:") && (strParts = line.split("\\s+")).length == 3) {
                    int mKb = Integer.parseInt(strParts[1]);
                    this.memMeg = mKb / 1024;
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void regReadCpu() {
        String cmd = "reg query HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor /s";
        try {
            String output = StaticTools.execGet(cmd, false);
            String[] lines = output.split("\\n");
            int myCores = 0;
            for (int i = 0; i < lines.length; ++i) {
                String zeroStr;
                String[] lineParts;
                String line = lines[i];
                if (line.contains("CentralProcessor\\")) {
                    ++myCores;
                }
                if (!line.contains("~MHz") || (lineParts = line.split("\\s+")).length != 4 || !(zeroStr = lineParts[3]).startsWith("0x")) continue;
                String noZero = zeroStr.substring(2, zeroStr.length());
                this.mhz = Integer.parseInt(noZero, 16);
            }
            this.cores = myCores;
            System.out.println(this.cores + " cores @ " + this.mhz + " MHz");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void wmicGetMem() {
        long memTotBytes = 0L;
        try {
            String chipInfo = StaticTools.execGet("wmic memorychip get capacity", false);
            String[] lines = chipInfo.split("\\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (line.length() <= 0 || !Character.isDigit(line.charAt(0))) continue;
                long lineMem = Long.parseLong(line);
                long toMegs = 0x100000L;
                this.memMeg = (int)((memTotBytes += lineMem) / toMegs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void sysctlReadCpuMem() {
        String myInfo;
        try {
            myInfo = StaticTools.execGet("sysctl -n hw.ncpu", false);
            System.out.println(myInfo);
            if (myInfo != null) {
                myInfo = myInfo.trim();
                this.cores = Integer.parseInt(myInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            myInfo = StaticTools.execGet("sysctl -n hw.physmem", false);
            if (myInfo != null) {
                myInfo = myInfo.trim();
                long memBytes = Long.parseLong(myInfo);
                long toMegs = 0x100000L;
                long memLong = memBytes / toMegs;
                this.memMeg = (int)memLong;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            myInfo = StaticTools.execGet("sysctl -n hw.cpufrequency", false);
            System.out.println("hw.cpufrequency " + myInfo);
            if (myInfo != null) {
                myInfo = myInfo.trim();
                long freqHz = Long.parseLong(myInfo);
                long toMhz = 1000000L;
                long mhzLong = freqHz / toMhz;
                System.out.println(" now " + mhzLong);
                if (mhzLong > 1000000L && myInfo.endsWith("000000")) {
                    mhzLong /= toMhz;
                }
                this.mhz = (int)mhzLong;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

