/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class PrefPrograms {
    private static HashMap traverseHm = new HashMap();

    public static void nomain(String[] args) {
        String userHome = System.getProperty("user.home");
        String exPropName = userHome + "/.executor.preferences";
        HashMap h = PrefPrograms.getSupportedPrograms(exPropName);
        System.out.println(h.size() + " supported.");
    }

    public static HashMap getSupportedPrograms(String exPropName) {
        HashMap hm = new HashMap();
        ArrayList<String> myPrgList = new ArrayList<String>();
        ArrayList<String> myExtList = new ArrayList<String>();
        PrefPrograms.doPreferencesFile(exPropName);
        try {
            Properties exProp = new Properties();
            exProp.load(new FileInputStream(exPropName));
            Set<Object> keySet = exProp.keySet();
            for (String string : keySet) {
                String vals = (String)exProp.get(string);
                String[] singleVals = vals.split(",\\s*");
                for (int i = 0; i < singleVals.length; ++i) {
                    String val = singleVals[i];
                    if (!string.startsWith(".")) continue;
                    myPrgList.add(val);
                    myExtList.add(string);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        hm = PrefPrograms.checkSupportedPrograms(myPrgList, myExtList);
        return hm;
    }

    static HashMap checkSupportedPrograms(List wantedPrograms, List exts) {
        String osName = System.getProperty("os.name");
        HashMap retMe = null;
        retMe = osName.startsWith("Windows") ? PrefPrograms.checkSupportedProgramsWindows(wantedPrograms, exts) : PrefPrograms.checkSupportedProgramsUnix(wantedPrograms, exts);
        return retMe;
    }

    static HashMap checkSupportedProgramsUnix(List wantedPrograms, List exts) {
        return PrefPrograms.checkByDirectCall(wantedPrograms, exts, "which");
    }

    static HashMap checkByDirectCall(List wantedPrograms, List exts, String callMethod) {
        HashMap hm = new HashMap();
        for (int i = 0; i < wantedPrograms.size(); ++i) {
            String osname;
            String ext = (String)exts.get(i);
            String prg = (String)wantedPrograms.get(i);
            String[] prgArgs = prg.split(" ", 2);
            prg = prgArgs[0];
            String args = "";
            if (prgArgs.length > 1) {
                args = " " + prgArgs[1].trim();
            }
            String cmd = prg + " -version";
            if (callMethod.equals("which")) {
                cmd = "which " + prg;
            }
            if ((osname = System.getProperty("os.name")).startsWith("Windows") && prg.toLowerCase().equals("cmd")) {
                hm = PrefPrograms.addInHash(hm, ext, prg, "cmd" + args);
                continue;
            }
            try {
                Process process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String s = stdInput.readLine();
                if (s == null) continue;
                if (callMethod.equals("-version")) {
                    s = prg;
                }
                if (s.startsWith("no ")) continue;
                hm = PrefPrograms.addInHash(hm, ext, prg, s + args);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return hm;
    }

    static HashMap checkSupportedProgramsWindows(List wantedPrograms, List exts) {
        traverseHm = PrefPrograms.checkByDirectCall(wantedPrograms, exts, "-version");
        String query = "reg query HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion";
        String prgFiles = "C:\\Program Files";
        try {
            Process process = Runtime.getRuntime().exec(query);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String s = "";
            while ((s = stdInput.readLine()) != null) {
                int regszPos;
                if (s.indexOf("ProgramFilesDir") <= 0 || (regszPos = s.indexOf("REG_SZ")) <= 0) continue;
                String after = s.substring(regszPos + 6, s.length());
                prgFiles = after = after.trim();
            }
            PrefPrograms.traverseSeek(new File(prgFiles), wantedPrograms, exts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return traverseHm;
    }

    static void traverseSeek(File node, List programs, List exts) {
        block4: {
            String nodeName;
            block3: {
                nodeName = node.getAbsoluteFile().getName();
                nodeName = nodeName.toLowerCase();
                if (!node.isDirectory()) break block3;
                String[] subNode = node.list();
                if (subNode == null) break block4;
                for (int i = 0; i < subNode.length; ++i) {
                    String fileName = subNode[i];
                    PrefPrograms.traverseSeek(new File(node, fileName), programs, exts);
                }
                break block4;
            }
            for (int i = 0; i < programs.size(); ++i) {
                String prgName = (String)programs.get(i);
                String[] prgArgs = prgName.split(" ", 2);
                prgName = prgArgs[0];
                String args = "";
                if (prgArgs.length > 1) {
                    args = " " + prgArgs[1].trim();
                }
                if (nodeName.indexOf((prgName = prgName.toLowerCase()) + ".exe") != 0) continue;
                String thisExt = (String)exts.get(i);
                String path = node.getAbsolutePath();
                path = path.replace("\\", "\\\\");
                path = "\"" + path + "\"";
                System.out.println("found " + path);
                path = path + args;
                traverseHm = PrefPrograms.addInHash(traverseHm, thisExt, prgName, path);
            }
        }
    }

    static HashMap addInHash(HashMap orig, String ext, String prg, String full) {
        String[] proCom = new String[]{prg, full};
        orig.put(ext, proCom);
        return orig;
    }

    static Properties doPreferencesFile(String exPropName) {
        Properties exProp = new Properties();
        exProp.setProperty(".py", "python");
        exProp.setProperty(".pl", "perl");
        exProp.setProperty(".r", "R --vanilla <");
        exProp.setProperty(".do", "stataSE /e, stata /e");
        exProp.setProperty(".tex", "pdflatex -halt-on-error");
        exProp.setProperty(".sh", "bash");
        exProp.setProperty(".mpi", "mpirun");
        exProp.setProperty(".jar", "java -jar");
        exProp.setProperty(".bat", "cmd /q /c");
        exProp.setProperty(".cmd", "cmd /q /c");
        exProp.setProperty(".exe", "cmd /q /c");
        boolean readOK = true;
        try {
            File exPropF = new File(exPropName);
            if (exPropF.exists()) {
                exProp.load(new FileInputStream(exPropName));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            FileOutputStream exPropFOS = new FileOutputStream(exPropName);
            exProp.store(exPropFOS, "Please exit the executor program before making changes in this file!");
            exPropFOS.flush();
            exPropFOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exProp;
    }
}

